/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Formula;

import Reika.DragonAPI.Instantiable.Formula.MathExpression;

public class ExponentialExpression
extends MathExpression {
    public final double baseVal;
    public final double scale;
    public final double base;

    public ExponentialExpression(double init, double scale, double base) {
        this.baseVal = init;
        this.scale = scale;
        this.base = base;
    }

    @Override
    public final double evaluate(double arg) throws ArithmeticException {
        return this.baseVal + this.scale * Math.pow(this.base, arg);
    }

    @Override
    public final double getBaseValue() {
        return this.baseVal;
    }

    @Override
    public final String toString() {
        return this.baseVal + (this.scale > 0.0 ? "+" : "-") + Math.abs(this.scale) + "*" + this.base + "^x";
    }
}

