/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;

public final class ProportionedMixMap<V, K> {
    private final PluralMap<K> data = new PluralMap(2);

    public void addMix(V e1, int amt1, V e2, int amt2, K out) {
        MixPut k1 = new MixPut(e1, amt1);
        MixPut k2 = new MixPut(e2, amt2);
        this.data.put(out, k1, k2);
    }

    public K getMix(V e1, int amt1, V e2, int amt2) {
        MixPut k1 = new MixPut(e1, amt1);
        MixPut k2 = new MixPut(e2, amt2);
        return this.data.get(k1, k2);
    }

    private static final class MixPut<V>
    implements Comparable<MixPut> {
        private final V entry;
        private final int amount;

        private MixPut(V v, int amt) {
            this.entry = v;
            this.amount = amt;
        }

        public int hashCode() {
            return this.entry.hashCode() ^ this.amount;
        }

        public boolean equals(Object o) {
            if (o instanceof MixPut) {
                MixPut m = (MixPut)o;
                return m.entry.equals(this.entry) && m.amount == this.amount;
            }
            return false;
        }

        @Override
        public int compareTo(MixPut o) {
            return this.entry == o.entry ? this.amount - o.amount : 0;
        }
    }
}

