/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalLineSegment;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public final class LineSegment {
    public final Coordinate origin;
    public final Coordinate target;

    public LineSegment(int x, int y, int z, int x2, int y2, int z2) {
        this.origin = new Coordinate(x, y, z);
        this.target = new Coordinate(x2, y2, z2);
    }

    public LineSegment(Coordinate c1, Coordinate c2) {
        this(c1.xCoord, c1.yCoord, c1.zCoord, c2.xCoord, c2.yCoord, c2.zCoord);
    }

    public static final LineSegment getFromXYZDir(int x1, int y1, int z1, ForgeDirection dir, int len) {
        return new LineSegment(x1, y1, z1, x1 + len * dir.offsetX, y1 + len * dir.offsetY, z1 + len * dir.offsetZ);
    }

    public static final LineSegment getFromXYZDir(int x1, int y1, int z1, ReikaDirectionHelper.CubeDirections dir, double len) {
        return new LineSegment(x1, y1, z1, MathHelper.func_76128_c((double)((double)x1 + len * dir.offsetX)), y1, MathHelper.func_76128_c((double)((double)z1 + len * dir.offsetZ)));
    }

    public double getLength() {
        return this.target.getDistanceTo(this.origin);
    }

    public String toString() {
        return this.origin.toString() + " >> " + this.target.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof LineSegment) {
            LineSegment ls = (LineSegment)o;
            return ls.origin.equals(this.origin) && ls.target.equals(this.target);
        }
        return false;
    }

    public int hashCode() {
        return this.origin.hashCode() ^ this.target.hashCode();
    }

    public DecimalLineSegment asDecimalSegment() {
        return new DecimalLineSegment(new DecimalPosition(this.origin), new DecimalPosition(this.target));
    }
}

