/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockKey
implements BlockCheck,
Comparable<BlockKey> {
    public final Block blockID;
    public final int metadata;
    public static final BlockKey AIR = new BlockKey(Blocks.field_150350_a);

    public BlockKey(Block b) {
        this(b, -1);
    }

    public BlockKey(Block b, int meta) {
        this.metadata = meta;
        this.blockID = b;
        if (b == null) {
            throw new MisuseException("Cannot create a BlockKey from a null block!");
        }
    }

    public BlockKey(ItemStack is) {
        this(Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j());
        if (is.func_77973_b() == null) {
            throw new MisuseException("Cannot create a BlockKey from a null item!");
        }
        Block b = Block.func_149634_a((Item)is.func_77973_b());
        if (b == null) {
            throw new MisuseException("Cannot create a BlockKey with an item with no block!");
        }
    }

    public BlockKey(TileEnum m) {
        this.metadata = m.getBlockMetadata();
        this.blockID = m.getBlock();
    }

    public static BlockKey getAt(IBlockAccess world, int x, int y, int z) {
        return new BlockKey(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public static BlockKey getAtNoMeta(IBlockAccess world, int x, int y, int z) {
        return new BlockKey(world.func_147439_a(x, y, z), -1);
    }

    public int hashCode() {
        return this.blockID.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BlockKey) {
            BlockKey b = (BlockKey)o;
            return b.blockID == this.blockID && (!this.hasMetadata() || !b.hasMetadata() || b.metadata == this.metadata);
        }
        return false;
    }

    public String toString() {
        return this.blockID.func_149739_a() + ":" + this.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata >= 0 && this.metadata != Short.MAX_VALUE;
    }

    @Override
    public ItemStack asItemStack() {
        return new ItemStack(this.blockID, 1, this.hasMetadata() ? this.metadata : 0);
    }

    @Override
    public ItemStack getDisplay() {
        return this.asItemStack();
    }

    @Override
    public boolean match(Block b, int meta) {
        return b == this.blockID && (!this.hasMetadata() || meta == this.metadata);
    }

    @Override
    public boolean matchInWorld(World world, int x, int y, int z) {
        return this.match(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public void place(World world, int x, int y, int z) {
        this.place(world, x, y, z, 3);
    }

    @Override
    public void place(World world, int x, int y, int z, int flags) {
        world.func_147465_d(x, y, z, this.blockID, this.hasMetadata() ? this.metadata : 0, flags);
    }

    @Override
    public BlockKey asBlockKey() {
        return this;
    }

    public String getLocalized() {
        return this.blockID.func_149732_F() + ":" + this.metadata;
    }

    public void writeToNBT(String tag, NBTTagCompound NBT) {
        NBTTagCompound dat = new NBTTagCompound();
        dat.func_74778_a("id", Block.field_149771_c.func_148750_c((Object)this.blockID));
        dat.func_74768_a("meta", this.metadata);
        NBT.func_74782_a(tag, (NBTBase)dat);
    }

    public static BlockKey readFromNBT(String tag, NBTTagCompound NBT) {
        NBTTagCompound dat = NBT.func_74775_l(tag);
        String id = dat.func_74779_i("id");
        Block b = Strings.isNullOrEmpty((String)id) ? null : Block.func_149684_b((String)id);
        int meta = dat.func_74762_e("meta");
        return b != null ? new BlockKey(b, meta) : null;
    }

    @Override
    public boolean match(BlockCheck bc) {
        return bc instanceof BlockKey && ((BlockKey)bc).equals(this);
    }

    public int getBlockID() {
        return Block.func_149682_b((Block)this.blockID);
    }

    @Override
    public int compareTo(BlockKey o) {
        return 100000 * Integer.compare(this.getBlockID(), o.getBlockID()) + Integer.compare(this.getMetadataForCompare(), o.getMetadataForCompare());
    }

    private int getMetadataForCompare() {
        if (this.metadata == -1 || this.metadata == Short.MAX_VALUE) {
            return 65536;
        }
        return this.metadata;
    }
}

