/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.Data.CircularDivisionRenderer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class Compass<F>
extends CircularDivisionRenderer<F> {
    public final CompassDivisions divisions;
    private final Map<ReikaDirectionHelper.FanDirections, F> data = new HashMap<ReikaDirectionHelper.FanDirections, F>();

    public Compass(CompassDivisions d) {
        this.divisions = d;
    }

    public void addValue(ReikaDirectionHelper.FanDirections dir, F val) {
        this.data.put(dir, val);
        if (val instanceof CircularDivisionRenderer.ColorCallback) {
            this.addColorRenderer(val, (CircularDivisionRenderer.ColorCallback)val);
        }
        this.resetColors();
    }

    public void removeValue(ReikaDirectionHelper.FanDirections dir) {
        this.data.remove((Object)dir);
        this.resetColors();
    }

    public F getValue(ReikaDirectionHelper.FanDirections dir) {
        return this.data.get((Object)dir);
    }

    @Override
    public Collection<F> getElements() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    @Override
    public void clear() {
        this.data.clear();
        this.resetColors();
    }

    @Override
    public F getClickedSection(int x, int y) {
        double d = ReikaMathLibrary.py3d((double)x - this.centerX, (double)y - this.centerY, 0.0);
        if (d > this.renderRadius) {
            return null;
        }
        double mouseAng = (Math.toDegrees(Math.atan2((double)y - this.centerY, (double)x - this.centerX)) + 360.0) % 360.0;
        for (Map.Entry<ReikaDirectionHelper.FanDirections, F> e : this.data.entrySet()) {
            ReikaDirectionHelper.FanDirections dir = e.getKey();
            double ang1 = this.renderOrigin - dir.angle - this.divisions.angleSize / 2.0;
            double ang2 = this.renderOrigin - dir.angle + this.divisions.angleSize / 2.0;
            if (!(ang1 < mouseAng) || !(ang2 > mouseAng)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Map<F, Integer> colorMap) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        Tessellator v5 = Tessellator.field_78398_a;
        boolean i = false;
        for (Map.Entry<ReikaDirectionHelper.FanDirections, F> e : this.data.entrySet()) {
            ReikaDirectionHelper.FanDirections dir = e.getKey();
            double ang1 = this.renderOrigin - dir.angle - this.divisions.angleSize / 2.0;
            double ang2 = this.renderOrigin - dir.angle + this.divisions.angleSize / 2.0;
            F o = e.getValue();
            v5.func_78371_b(this.innerRadius == 0.0 ? 6 : 5);
            int c = this.getColorForElement(o, colorMap);
            v5.func_78378_d(c);
            this.renderSection(v5, ang1, ang2);
            v5.func_78381_a();
        }
        GL11.glPopAttrib();
    }

    public static enum CompassDivisions {
        CARDINAL(4),
        OCTAGON(8),
        FULL(16);

        public final double angleSize;

        private CompassDivisions(int n2) {
            this.angleSize = 360.0 / (double)n2;
        }

        public Collection<ReikaDirectionHelper.FanDirections> getDirections() {
            HashSet<ReikaDirectionHelper.FanDirections> ret = new HashSet<ReikaDirectionHelper.FanDirections>();
            switch (this) {
                case CARDINAL: {
                    ret.add(ReikaDirectionHelper.FanDirections.E);
                    ret.add(ReikaDirectionHelper.FanDirections.S);
                    ret.add(ReikaDirectionHelper.FanDirections.W);
                    ret.add(ReikaDirectionHelper.FanDirections.N);
                }
                case OCTAGON: {
                    ret.add(ReikaDirectionHelper.FanDirections.NE);
                    ret.add(ReikaDirectionHelper.FanDirections.SE);
                    ret.add(ReikaDirectionHelper.FanDirections.NW);
                    ret.add(ReikaDirectionHelper.FanDirections.SW);
                }
                case FULL: {
                    ret.add(ReikaDirectionHelper.FanDirections.NNE);
                    ret.add(ReikaDirectionHelper.FanDirections.ENE);
                    ret.add(ReikaDirectionHelper.FanDirections.ESE);
                    ret.add(ReikaDirectionHelper.FanDirections.SSE);
                    ret.add(ReikaDirectionHelper.FanDirections.SSW);
                    ret.add(ReikaDirectionHelper.FanDirections.WSW);
                    ret.add(ReikaDirectionHelper.FanDirections.WNW);
                    ret.add(ReikaDirectionHelper.FanDirections.NNW);
                }
            }
            return ret;
        }
    }
}

