/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public final class ChancedOutputList {
    private final ArrayList<ItemWithChance> data = new ArrayList();
    private boolean modifiable = true;
    private final boolean allowOverflow;

    public ChancedOutputList(boolean allowOver100) {
        this.allowOverflow = false;
    }

    public ChancedOutputList(boolean allowOver100, ItemHashMap<Float> output) {
        this(allowOver100);
        for (ItemStack is : output.keySet()) {
            this.putItem(is.func_77946_l(), output.get(is).floatValue());
        }
    }

    public ChancedOutputList(boolean allowOver100, Collection<ItemWithChance> output) {
        this(allowOver100);
        for (ItemWithChance is : output) {
            this.data.add(is);
        }
    }

    public ChancedOutputList(boolean allowOver100, ItemStack[] items, float ... chances) {
        this(allowOver100);
        for (int i = 0; i < items.length; ++i) {
            this.putItem(items[i].func_77946_l(), chances[i]);
        }
    }

    public ChancedOutputList addItem(ItemStack is, float chance) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This ChancedOutputList is locked!");
        }
        this.putItem(is, chance);
        return this;
    }

    private void putItem(ItemStack is, float chance) {
        this.data.add(new ItemWithChance(is, chance));
    }

    public void removeItem(ItemStack is) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This ChancedOutputList is locked!");
        }
        Iterator<ItemWithChance> it = this.data.iterator();
        while (it.hasNext()) {
            ItemWithChance ic = it.next();
            if (!ItemStack.func_77989_b((ItemStack)is, (ItemStack)ic.item)) continue;
            it.remove();
        }
    }

    public ChancedOutputList addItems(ArrayList<ItemStack> li, float chance) {
        for (ItemStack is : li) {
            this.addItem(is, chance);
        }
        return this;
    }

    public Collection<ItemStack> itemSet() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (ItemWithChance ic : this.data) {
            c.add(ic.getItem());
        }
        return c;
    }

    public Collection<ItemWithChance> keySet() {
        return Collections.unmodifiableCollection(this.data);
    }

    public ArrayList<ItemStack> getAllWithChance(float chance) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemWithChance key : this.data) {
            if (key.chance != chance) continue;
            li.add(key.getItem());
        }
        return li;
    }

    public ArrayList<ItemStack> getAllWithAtLeastChance(float chance) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemWithChance key : this.data) {
            if (!(key.chance >= chance)) continue;
            li.add(key.getItem());
        }
        return li;
    }

    public ArrayList<ItemStack> calculate() {
        return this.calculate(1.0);
    }

    public ArrayList<ItemStack> calculate(double factor) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemWithChance key : this.data) {
            double ch;
            float c = key.chance;
            if (this.allowOverflow) {
                for (ch = factor * (double)c / 100.0; ch >= 1.0; ch -= 1.0) {
                    li.add(key.getItem());
                }
            }
            if (!(ch >= 1.0) && !ReikaRandomHelper.doWithChance(ch)) continue;
            li.add(key.getItem());
        }
        return li;
    }

    public ChancedOutputList copy() {
        return new ChancedOutputList(this.allowOverflow, this.data);
    }

    public ChancedOutputList lock() {
        this.modifiable = false;
        return this;
    }

    public String toString() {
        return this.data.toString();
    }

    public void manipulateChances(ChanceManipulator cm) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This ChancedOutputList is locked!");
        }
        for (ItemWithChance is : this.data) {
            float c = cm.getChance(is.chance);
            if (!this.allowOverflow) {
                c = MathHelper.func_76131_a((float)c, (float)0.0f, (float)100.0f);
            }
            is.chance = c;
        }
    }

    public int size() {
        return this.data.size();
    }

    public static ChancedOutputList parseFromArray(boolean allowOver100, Object[] arr) {
        if (arr.length % 2 != 0) {
            throw new MisuseException("Every item must have a specified chance!");
        }
        ChancedOutputList c = new ChancedOutputList(allowOver100);
        for (int i = 0; i < arr.length; i += 2) {
            ItemStack is = ReikaItemHelper.parseItem(arr[i]);
            if (is == null) continue;
            Object chance = arr[i + 1];
            if (chance instanceof Integer) {
                chance = new Float(((Integer)chance).intValue());
            }
            c.addItem(is, ((Float)chance).floatValue());
        }
        return c;
    }

    public static class ItemWithChance {
        private final ItemStack item;
        private float chance;

        private ItemWithChance(ItemStack is, float c) {
            this.item = is;
            this.chance = c;
        }

        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        public final float getChance() {
            return this.chance;
        }

        public float getNormalizedChance() {
            float f = this.getChance();
            return Math.min(1.0f, f / 100.0f);
        }

        public String toString() {
            return this.item.func_82833_r() + ": " + this.chance + "%";
        }
    }

    public static class ChanceExponentiator
    implements ChanceManipulator {
        private final double power;

        public ChanceExponentiator(double power) {
            this.power = power;
        }

        @Override
        public float getChance(float original) {
            double p = (double)original / 100.0;
            double num = Math.pow(p, 1.0 / this.power);
            return (float)(100.0 * num);
        }
    }

    public static class ChanceMultiplier
    implements ChanceManipulator {
        private final float factor;

        public ChanceMultiplier(float factor) {
            this.factor = factor;
        }

        @Override
        public float getChance(float original) {
            return original * this.factor;
        }
    }

    public static interface ChanceManipulator {
        public float getChance(float var1);
    }
}

