/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.MusicScore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public final class ReikaMIDIReader {
    public static final int NOTE_ON = 144;
    public static final int NOTE_OFF = 128;
    public static final int INSTRU_CHANGE = 192;
    public static final int TEMPO = 81;
    public static final String[] NOTE_NAMES = new String[]{"F#", "G", "G#", "A", "Bb", "B", "C", "C#", "D", "Eb", "E", "F"};
    public static final int MIDI_C5 = 60;

    private ReikaMIDIReader() {
        throw new RuntimeException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static Sequence getMIDIFromFile(Class root, String path) {
        DragonAPICore.log("Reading MIDI at " + path);
        InputStream input = root.getResourceAsStream(path);
        if (input == null) {
            DragonAPICore.logError("File at " + path + " not found. Aborting.");
            return null;
        }
        try {
            return ReikaMIDIReader.readMIDIFromFile(input);
        }
        catch (IOException e) {
            DragonAPICore.logError("MIDI File at " + path + " unreadable.");
        }
        catch (InvalidMidiDataException e) {
            DragonAPICore.logError("MIDI File at " + path + " invalid.");
        }
        return null;
    }

    public static Sequence getMIDIFromFile(File f) {
        try {
            return ReikaMIDIReader.readMIDIFromFile(new FileInputStream(f));
        }
        catch (IOException e) {
            DragonAPICore.logError("MIDI File at " + f.getAbsolutePath() + " unreadable.");
        }
        catch (InvalidMidiDataException e) {
            DragonAPICore.logError("MIDI File at " + f.getAbsolutePath() + " invalid.");
        }
        return null;
    }

    public static Sequence getMIDIFromFile(InputStream in) {
        try {
            return ReikaMIDIReader.readMIDIFromFile(in);
        }
        catch (IOException e) {
            DragonAPICore.logError("MIDI File unreadable.");
        }
        catch (InvalidMidiDataException e) {
            DragonAPICore.logError("MIDI File invalid.");
        }
        return null;
    }

    private static Sequence readMIDIFromFile(InputStream in) throws IOException, InvalidMidiDataException {
        return MidiSystem.getSequence(in);
    }

    public static void debugMIDI(Sequence sequence) {
        if (sequence == null) {
            DragonAPICore.logError("Debugged MIDI is null!");
            return;
        }
        int trackNumber = 0;
        for (Track track : sequence.getTracks()) {
            System.out.println("Track " + ++trackNumber + ": size = " + track.size());
            System.out.println();
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                System.out.print("@" + event.getTick() + " ");
                MidiMessage message = event.getMessage();
                if (message instanceof ShortMessage) {
                    int velocity;
                    String noteName;
                    int note;
                    int octave;
                    int key;
                    ShortMessage sm = (ShortMessage)message;
                    System.out.print("Channel: " + sm.getChannel() + " ");
                    if (sm.getCommand() == 144) {
                        key = sm.getData1();
                        octave = key / 12 - 1;
                        note = key % 12;
                        noteName = NOTE_NAMES[note];
                        velocity = sm.getData2();
                        System.out.println("Note on, " + noteName + octave + " key=" + key + " velocity: " + velocity);
                        continue;
                    }
                    if (sm.getCommand() == 128) {
                        key = sm.getData1();
                        octave = key / 12 - 1;
                        note = key % 12;
                        noteName = NOTE_NAMES[note];
                        velocity = sm.getData2();
                        System.out.println("Note off, " + noteName + octave + " key=" + key + " velocity: " + velocity);
                        continue;
                    }
                    if (sm.getCommand() == 192) {
                        System.out.println("Instrument change " + sm.getCommand());
                        continue;
                    }
                    System.out.println("Command:" + sm.getCommand());
                    continue;
                }
                System.out.println("Other message: " + message.getClass());
            }
            System.out.println();
        }
    }

    public static int getMidiLength(Sequence seq) {
        return ReikaMIDIReader.getSequenceLength(seq);
    }

    private static int getSequenceLength(Sequence seq) {
        if (seq == null) {
            return 0;
        }
        Track[] tr = seq.getTracks();
        int length = 0;
        for (int i = 0; i < tr.length; ++i) {
            if (tr[i].size() <= length) continue;
            length = tr[i].size();
        }
        return length;
    }

    public static int MIDITickToMCTick(Sequence seq, long ti, float bpm) {
        return (int)((float)ti * ReikaMIDIReader.getMillisPerTick(seq, bpm) / 5.0f);
    }

    public static long MCTickToMIDITick(Sequence seq, int ti, float bpm) {
        return (long)((float)ti / ReikaMIDIReader.getMillisPerTick(seq, bpm) * 5.0f);
    }

    private static float getMillisPerTick(Sequence seq, float bpm) {
        return 60000.0f / ((float)seq.getResolution() * bpm);
    }

    private static long getMIDITickLength(Sequence seq) {
        if (seq == null) {
            return 0L;
        }
        Track[] tr = seq.getTracks();
        long length = 0L;
        for (int i = 0; i < tr.length; ++i) {
            if ((long)tr[i].size() <= length) continue;
            length = tr[i].ticks();
        }
        return length;
    }

    private static int getMCTickLength(Sequence seq) {
        return ReikaMIDIReader.MIDITickToMCTick(seq, ReikaMIDIReader.getMIDITickLength(seq), 90.0f);
    }

    public static int[][][] readMIDIFileToArray(Sequence seq) {
        int[][][] data = new int[ReikaMIDIReader.getMCTickLength(seq)][64][3];
        if (seq == null) {
            DragonAPICore.logError("Sequence is empty!");
            return data;
        }
        int[][] dataline = new int[16][3];
        int vol = 0;
        int voice = 0;
        int note = 0;
        int instru = 0;
        int tempo = 120;
        Track[] tr = seq.getTracks();
        for (int i = 0; i < tr.length; ++i) {
            for (int j = 0; j < tr[i].size(); ++j) {
                MidiEvent event = tr[i].get(j);
                int time = ReikaMIDIReader.MIDITickToMCTick(seq, event.getTick(), tempo);
                MidiMessage message = event.getMessage();
                if (message instanceof ShortMessage) {
                    ShortMessage sm = (ShortMessage)message;
                    int channel = i - 1;
                    if (channel == -1) {
                        throw new RuntimeException("Invalid MIDI has notes in the tempo track (track 0)!");
                    }
                    switch (sm.getCommand()) {
                        case 144: {
                            int key = sm.getData1();
                            int octave = key / 12 - 1;
                            int relnote = key % 12;
                            note = key - 24;
                            vol = sm.getData2();
                            voice = instru;
                            int a = 0;
                            dataline[channel][0] = ReikaMIDIReader.getNoteblockFromGM(voice);
                            if (dataline[channel][0] == 2) {
                                a = 12;
                            }
                            if (dataline[channel][0] == 3) {
                                a = -12;
                            }
                            dataline[channel][1] = note + a;
                            dataline[channel][2] = vol;
                            break;
                        }
                        case 128: {
                            break;
                        }
                        case 192: {
                            instru = sm.getData1();
                        }
                    }
                    if (dataline[channel][0] == 0 || sm.getCommand() != 144) continue;
                    for (int k = 0; k < 16; ++k) {
                        for (int l = 0; l < 3; ++l) {
                            data[time][k][l] = dataline[k][l];
                        }
                    }
                    continue;
                }
                if (!(message instanceof MetaMessage)) continue;
                MetaMessage mm = (MetaMessage)message;
                byte[] bytes = mm.getData();
                int val = (bytes[0] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[2] & 0xFF;
                switch (mm.getType()) {
                    case 81: {
                        tempo = 60000000 / val;
                    }
                }
            }
        }
        return data;
    }

    public static MusicScore readMIDIFileToScore(Sequence seq, boolean readPercussion) {
        int i;
        MusicScore data = new MusicScore(16);
        if (seq == null) {
            DragonAPICore.logError("Sequence is empty!");
            return data;
        }
        int key = 0;
        int instru = 0;
        int tempo = 120;
        Track[] tr = seq.getTracks();
        ArrayList[] rawNotes = new ArrayList[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            rawNotes[i2] = new ArrayList();
        }
        MIDINote[][] lastOn = new MIDINote[16][256];
        HashSet<Integer> activeChannels = new HashSet<Integer>();
        TreeMap<Long, Integer> tempoCurve = new TreeMap<Long, Integer>();
        tempoCurve.put(0L, tempo);
        for (i = 0; i < tr.length; ++i) {
            for (int j = 0; j < tr[i].size(); ++j) {
                MetaMessage mm;
                byte[] bytes;
                MidiEvent event = tr[i].get(j);
                long tick = event.getTick();
                MidiMessage message = event.getMessage();
                if (message instanceof ShortMessage) {
                    ShortMessage sm = (ShortMessage)message;
                    int channel = sm.getChannel();
                    if (channel == 9 && !readPercussion) continue;
                    if (channel >= 16) {
                        throw new RuntimeException("Invalid MIDI has more than 16 tracks!?!");
                    }
                    activeChannels.add(channel);
                    switch (sm.getCommand()) {
                        case 144: {
                            key = sm.getData1();
                            int vol = sm.getData2();
                            lastOn[channel][key] = new MIDINote(tick, key, instru, vol);
                            break;
                        }
                        case 128: {
                            key = sm.getData1();
                            break;
                        }
                        case 192: {
                            instru = sm.getData1();
                        }
                    }
                    if (lastOn[channel][key] == null || sm.getCommand() != 128) continue;
                    MIDINote m = lastOn[channel][key];
                    ReikaMusicHelper.MusicKey note = ReikaMusicHelper.MusicKey.getKeyFromMIDI(key);
                    rawNotes[channel].add(new NoteData(tick, m));
                    lastOn[channel][key] = null;
                    continue;
                }
                if (!(message instanceof MetaMessage) || (bytes = (mm = (MetaMessage)message).getData()).length != 3) continue;
                int val = (bytes[0] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[2] & 0xFF;
                switch (mm.getType()) {
                    case 81: {
                        tempo = 60000000 / val;
                        tempoCurve.put(tick, tempo);
                    }
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            ArrayList li = rawNotes[i];
            if (li.isEmpty()) continue;
            for (NoteData n : li) {
                int timeOn = ReikaMIDIReader.getTimeAtTick(seq, tempoCurve, n.tickOn);
                int timeOff = ReikaMIDIReader.getTimeAtTick(seq, tempoCurve, n.tickOff);
                ReikaMusicHelper.MusicKey note = ReikaMusicHelper.MusicKey.getKeyFromMIDI(n.pitch);
                data.addNote(timeOn, i, note, n.voice, n.velocity, timeOff - timeOn, i == 9);
            }
        }
        return data;
    }

    private static int getTimeAtTick(Sequence seq, TreeMap<Long, Integer> tempos, long tick) {
        Map.Entry<Long, Integer> e2 = tempos.floorEntry(tick);
        long ticks = tick - e2.getKey();
        int tempo = e2.getValue();
        int mcticks = ReikaMIDIReader.MIDITickToMCTick(seq, ticks, tempo);
        Map.Entry<Long, Integer> e1 = tempos.lowerEntry(e2.getKey());
        while (e1 != null) {
            ticks = e2.getKey() - e1.getKey();
            tempo = e1.getValue();
            mcticks += ReikaMIDIReader.MIDITickToMCTick(seq, ticks, tempo);
            e2 = e1;
            e1 = tempos.lowerEntry(e1.getKey());
        }
        return mcticks;
    }

    public static int getNoteblockFromGM(int v) {
        switch (v) {
            case 0: {
                return 1;
            }
            case 32: {
                return 2;
            }
            case 18: {
                return 3;
            }
        }
        return 0;
    }

    private static class NoteData
    extends MIDINote {
        public final long tickOff;

        protected NoteData(long tk, MIDINote start) {
            super(start);
            this.tickOff = tk;
        }

        public long length() {
            return this.tickOff - this.tickOn;
        }

        @Override
        public String toString() {
            return super.toString() + " Tick Off: " + this.tickOff + " (len = " + this.length() + ")";
        }
    }

    private static class MIDINote {
        public final long tickOn;
        public final int pitch;
        public final int voice;
        public final int velocity;

        protected MIDINote(MIDINote m) {
            this(m.tickOn, m.pitch, m.voice, m.velocity);
        }

        protected MIDINote(long tk, int key, int inst, int vol) {
            this.tickOn = tk;
            this.pitch = key;
            this.velocity = vol;
            this.voice = inst;
        }

        public String toString() {
            return String.format("Tick: %d, P:%d, Vel:%d, Voice:%d", this.tickOn, this.pitch, this.velocity, this.voice);
        }
    }
}

