/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ReikaFileReader
extends DragonAPICore {
    private static long internetLastUnavailable = -1L;

    public static int getFileLength(File f) {
        int len;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            lnr.skip(Long.MAX_VALUE);
            len = lnr.getLineNumber() + 1 + 1;
            lnr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load file data due to " + e.getCause() + " and " + e.getClass() + " !");
        }
        return len;
    }

    public static BufferedReader getReader(File f) {
        try {
            return new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(InputStream in) {
        try {
            return new BufferedReader(new InputStreamReader(in));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(String path) {
        try {
            return new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(URL url, int timeout, ConnectionErrorHandler ch, DataFetcher f) {
        if (!ReikaFileReader.isInternetAccessible(timeout)) {
            if (ch != null) {
                ch.onNoInternet();
            }
            return null;
        }
        try {
            URLConnection c = url.openConnection();
            c.setConnectTimeout(timeout);
            if (f != null) {
                try {
                    f.fetchData(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new BufferedReader(new InputStreamReader(c.getInputStream()));
        }
        catch (UnknownHostException e) {
            if (ch != null) {
                ch.onServerNotFound();
            }
        }
        catch (ConnectException e) {
            if (ch != null) {
                ch.onServerRedirected();
            }
        }
        catch (SocketTimeoutException e) {
            if (ch != null) {
                ch.onTimedOut();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean isInternetAccessible(int timeout) {
        if (ReikaObfuscationHelper.isDeObfEnvironment() && ReikaJVMParser.isArgumentPresent("-DragonAPI_NoInternet")) {
            DragonAPICore.log("Internet is marked inaccessible.");
            return false;
        }
        int dt = 60000 * (ReikaObfuscationHelper.isDeObfEnvironment() ? 5 : 1);
        if (internetLastUnavailable + (long)dt >= System.currentTimeMillis()) {
            return false;
        }
        String[] attempts = new String[]{"http://www.google.com", "http://en.wikipedia.org/wiki/Main_Page", "http://github.com/", "http://msdn.microsoft.com/en-us/default.aspx", "https://aws.amazon.com/", "ns1.telstra.net"};
        for (int i = 0; i < attempts.length; ++i) {
            try {
                URLConnection c = new URL(attempts[i]).openConnection();
                c.setConnectTimeout(timeout);
                ((HttpURLConnection)c).getResponseCode();
                return true;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        internetLastUnavailable = System.currentTimeMillis();
        return false;
    }

    public static ArrayList<File> getAllFilesInFolder(File f, String ... ext) {
        ArrayList<File> li = new ArrayList<File>();
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File in = files[i];
                if (in.isDirectory()) {
                    li.addAll(ReikaFileReader.getAllFilesInFolder(in, ext));
                    continue;
                }
                if (ext == null) {
                    li.add(in);
                    continue;
                }
                for (int k = 0; k < ext.length; ++k) {
                    if (!in.getName().endsWith(ext[k])) continue;
                    li.add(in);
                }
            }
        }
        return li;
    }

    public static ArrayList<File> getAllFilesInFolder(File f) {
        return ReikaFileReader.getAllFilesInFolder(f, null);
    }

    public static String readTextFile(Class root, String path) {
        BufferedReader p;
        InputStream in = root.getResourceAsStream(path);
        StringBuilder sb = new StringBuilder();
        try {
            p = new BufferedReader(new InputStreamReader(in));
        }
        catch (NullPointerException e) {
            DragonAPICore.logError("File " + path + " does not exist!");
            return sb.toString();
        }
        int i = 0;
        try {
            String line = null;
            while ((line = p.readLine()) != null) {
                if (line.isEmpty()) continue;
                sb.append(line);
                ++i;
                sb.append("\n");
            }
            p.close();
        }
        catch (Exception e) {
            DragonAPICore.logError(e.getMessage() + " on loading line " + i);
        }
        return sb.toString();
    }

    public static ArrayList<String> getFileAsLines(String path, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(ReikaFileReader.getReader(path), printStackTrace);
    }

    public static ArrayList<String> getFileAsLines(URL url, int timeout, boolean printStackTrace, ConnectionErrorHandler ch) {
        return ReikaFileReader.getFileAsLines(url, timeout, printStackTrace, ch, null);
    }

    public static ArrayList<String> getFileAsLines(URL url, int timeout, boolean printStackTrace, ConnectionErrorHandler ch, DataFetcher f) {
        BufferedReader r = ReikaFileReader.getReader(url, timeout, ch, f);
        return r != null ? ReikaFileReader.getFileAsLines(r, printStackTrace) : null;
    }

    public static ArrayList<String> getFileAsLines(File f, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(ReikaFileReader.getReader(f), printStackTrace);
    }

    public static ArrayList<String> getFileAsLines(InputStream in, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(ReikaFileReader.getReader(in), printStackTrace);
    }

    public static ArrayList<String> getFileAsLines(BufferedReader r, boolean printStackTrace) {
        ArrayList<String> li;
        block3: {
            li = new ArrayList<String>();
            String line = "";
            try {
                while (line != null) {
                    line = r.readLine();
                    if (line == null) continue;
                    li.add(line);
                }
                r.close();
            }
            catch (Exception e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
        return li;
    }

    public static ArrayList<Byte> getFileAsBytes(InputStream in, boolean printStackTrace) {
        ArrayList<Byte> li;
        block3: {
            BufferedReader r = ReikaFileReader.getReader(in);
            li = new ArrayList<Byte>();
            try {
                byte b = (byte)r.read();
                while (b != -1) {
                    li.add(b);
                    b = (byte)r.read();
                }
                r.close();
            }
            catch (Exception e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
        return li;
    }

    public static BufferedWriter getWriter(File f) {
        try {
            return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeLinesToFile(String s, ArrayList<String> li, boolean printStackTrace) {
        ReikaFileReader.writeLinesToFile(new File(s), li, printStackTrace);
    }

    public static void writeLinesToFile(File f, ArrayList<String> li, boolean printStackTrace) {
        block2: {
            try {
                ReikaFileReader.writeLinesToFile(new BufferedWriter(new PrintWriter(f)), li, printStackTrace);
            }
            catch (IOException e) {
                if (!printStackTrace) break block2;
                e.printStackTrace();
            }
        }
    }

    public static void writeLinesToFile(BufferedWriter p, ArrayList<String> li, boolean printStackTrace) {
        block3: {
            String sep = System.getProperty("line.separator");
            try {
                for (String s : li) {
                    p.write(s + sep);
                }
                p.flush();
                p.close();
            }
            catch (IOException e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void writeDataToFile(File f, ArrayList<Byte> li, boolean printStackTrace) {
        block3: {
            try {
                f.delete();
                f.getParentFile().mkdirs();
                f.createNewFile();
                FileOutputStream fos = new FileOutputStream(f);
                BufferedWriter p = new BufferedWriter(new OutputStreamWriter(fos));
                for (byte b : li) {
                    p.write(b);
                }
                p.flush();
                p.close();
            }
            catch (IOException e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
    }

    public static InputStream convertLinesToStream(ArrayList<String> li, boolean printStackTrace) {
        ByteArrayOutputStream bos;
        block3: {
            String sep = System.getProperty("line.separator");
            bos = new ByteArrayOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bos));
            try {
                for (String s : li) {
                    writer.write(s + sep);
                }
                writer.close();
            }
            catch (IOException e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    public static String getHash(String path, HashType type) {
        return ReikaFileReader.getHash(new File(path), type);
    }

    public static String getHash(File file, HashType type) {
        try {
            return ReikaFileReader.getHash(new FileInputStream(file), type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getHash(InputStream is, HashType type) {
        StringBuffer sb = new StringBuffer();
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(type.tag);
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            is.close();
            byte[] hash = complete.digest();
            for (int i = 0; i < hash.length; ++i) {
                sb.append(Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1).toUpperCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append("IO ERROR: ");
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public static InputStream getFileInsideJar(File f, String name) {
        try {
            return ReikaFileReader.getFileInsideJar(new JarFile(f), name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getFileInsideJar(JarFile jar, String name) {
        try {
            return jar.getInputStream(jar.getEntry(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean deleteFolderWithContents(File f) {
        return ReikaFileReader.deleteFolderWithContents(f, 10);
    }

    public static boolean deleteFolderWithContents(File f, int tries) {
        Throwable e = null;
        for (int i = 0; i < tries; ++i) {
            try {
                FileUtils.forceDelete((File)f);
                return true;
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        if (e != null) {
            e.printStackTrace();
        }
        return false;
    }

    public static void copyFile(InputStream in, OutputStream out, int size) throws FileReadException, FileWriteException {
        ReikaFileReader.copyFile(in, out, size, null);
    }

    public static void copyFile(InputStream in, OutputStream out, int chunkSize, WriteCallback call) throws FileReadException, FileWriteException {
        byte[] bytes = new byte[chunkSize];
        int count = 0;
        while (count != -1) {
            if (count > 0) {
                try {
                    out.write(bytes, 0, count);
                    if (call != null) {
                        call.onWrite(bytes);
                    }
                }
                catch (IOException e) {
                    throw new FileWriteException(e);
                }
            }
            try {
                count = in.read(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new FileReadException(e);
            }
        }
    }

    public static File createFileFromStream(InputStream in) throws IOException {
        File tempFile = File.createTempFile("temp_" + String.valueOf(in.hashCode()), null);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        return tempFile;
    }

    public static void writeUncompressedNBT(NBTTagCompound tag, File f) throws IOException {
        ReikaFileReader.writeUncompressedNBT(tag, new FileOutputStream(f));
    }

    public static void writeUncompressedNBT(NBTTagCompound tag, OutputStream out) throws IOException {
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)new DataOutputStream(out));
    }

    public static NBTTagCompound readUncompressedNBT(File f) throws IOException {
        return ReikaFileReader.readUncompressedNBT(new FileInputStream(f));
    }

    public static NBTTagCompound readUncompressedNBT(InputStream in) throws IOException {
        return CompressedStreamTools.func_152456_a((DataInput)new DataInputStream(in), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
    }

    public static boolean isEmpty(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = br.readLine();
        if (line == null || line.length() == 0 && br.readLine() == null) {
            br.close();
            return true;
        }
        br.close();
        return false;
    }

    public static void emptyDirectory(File dir) {
        File[] f = dir.listFiles();
        if (f == null) {
            return;
        }
        for (int i = 0; i < f.length; ++i) {
            f[i].delete();
        }
    }

    public static void clearFile(File f) {
        try {
            f.delete();
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void flipFileBytes(InputStream in, File out) {
        try {
            ArrayList<Byte> li = new ArrayList<Byte>();
            byte b = (byte)in.read();
            while (b != -1) {
                li.add(b);
                b = (byte)in.read();
            }
            Collections.reverse(li);
            ReikaFileReader.writeDataToFile(out, li, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayList<String> encryptFileBytes(InputStream in) {
        try {
            ArrayList<Byte> li = new ArrayList<Byte>();
            byte b = (byte)in.read();
            while (b != -1) {
                li.add(b);
                b = (byte)in.read();
            }
            ReikaFileReader.encryptByteList(li);
            ArrayList<String> li2 = new ArrayList<String>();
            String line = "";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < li.size(); ++i) {
                byte b2 = li.get(i);
                int val = Math.abs(b2);
                String s = String.valueOf(val);
                if (val < 10) {
                    s = "0" + s;
                }
                if (val < 100) {
                    s = "0" + s;
                }
                s = b2 < 0 ? "-" + s : "0" + s;
                sb.append(s);
                if (i % 56 != 55 && i != li.size() - 1) continue;
                li2.add(sb.toString());
                sb = new StringBuilder();
            }
            return li2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void encryptByteList(ArrayList<Byte> li) {
        Collections.reverse(li);
        for (int i = li.size() - 1; i >= 0; --i) {
            byte get = li.get(i);
            get = ReikaJavaLibrary.flipBits(get);
            get = ~get;
            li.set(i, get);
            li.add(i + 1, (byte)rand.nextInt(255));
        }
    }

    public static ArrayList<Byte> decryptFileBytes(InputStream in) {
        return ReikaFileReader.decryptByteList(ReikaFileReader.getFileAsLines(in, true));
    }

    public static ArrayList<Byte> decryptByteList(ArrayList<String> li2) {
        ArrayList<Byte> li = new ArrayList<Byte>();
        for (String s : li2) {
            List<String> arr = ReikaStringParser.splitStringByLength(s, 4);
            for (String s2 : arr) {
                byte b = Byte.parseByte(s2);
                li.add(b);
            }
        }
        Iterator it = li.iterator();
        int idx = 0;
        while (it.hasNext()) {
            byte b2 = (Byte)it.next();
            if (idx % 2 == 1) {
                it.remove();
            }
            ++idx;
        }
        for (int i = 0; i < li.size(); ++i) {
            byte get = (Byte)li.get(i);
            get = ~get;
            get = ReikaJavaLibrary.flipBits(get);
            li.set(i, get);
        }
        Collections.reverse(li);
        return li;
    }

    public static InputStream decryptInputStream(InputStream in) {
        ArrayList<Byte> data = ReikaFileReader.decryptFileBytes(in);
        ByteArrayOutputStream bin = new ByteArrayOutputStream();
        for (byte b : data) {
            bin.write(b);
        }
        return new ByteArrayInputStream(bin.toByteArray());
    }

    public static interface WriteCallback {
        public void onWrite(byte[] var1);
    }

    public static class FileWriteException
    extends IOException {
        private FileWriteException(IOException e) {
            super(e);
        }
    }

    public static class FileReadException
    extends IOException {
        private FileReadException(IOException e) {
            super(e);
        }
    }

    public static abstract class LineEditor {
        private final HashMap<Integer, String> lines = new HashMap();

        public abstract boolean editLine(String var1, int var2);

        protected abstract String getReplacementLine(String var1, String var2, int var3);

        public final boolean performChanges(File f) {
            try {
                BufferedReader r = new BufferedReader(new FileReader(f));
                String sep = System.getProperty("line.separator");
                String line = r.readLine();
                StringBuilder out = new StringBuilder();
                int idx = 1;
                while (line != null) {
                    String rep;
                    this.lines.put(idx, line);
                    String string = rep = this.editLine(line, idx) ? this.getReplacementLine(line, sep, idx) : line;
                    if (rep != null) {
                        out.append(rep + sep);
                    }
                    line = r.readLine();
                    ++idx;
                }
                r.close();
                FileOutputStream os = new FileOutputStream(f);
                os.write(out.toString().getBytes());
                os.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        protected final String getOriginalLine(int i) {
            return this.lines.get(i);
        }
    }

    public static enum HashType {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256");

        private final String tag;

        private HashType(String s) {
            this.tag = s;
        }

        public String hash(Object o) {
            return this.hashBytes(this.getBytes(o));
        }

        private String hashBytes(byte[] bytes) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.tag);
                messageDigest.update(bytes);
                return new String(messageDigest.digest(), StandardCharsets.UTF_8);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }

        private byte[] getBytes(Object o) {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            if (o instanceof Integer) {
                return ReikaJavaLibrary.splitIntToHexChars((Integer)o);
            }
            if (o instanceof String) {
                return ((String)o).getBytes();
            }
            if (o instanceof Serializable) {
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    ObjectOutputStream oo = new ObjectOutputStream(buf);
                    oo.writeObject(o);
                    return buf.toByteArray();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DragonAPICore.logError("Cannot serialize an object " + o + " of type " + o.getClass() + "!");
            return new byte[0];
        }
    }

    public static interface DataFetcher {
        public void fetchData(URLConnection var1) throws Exception;
    }

    public static interface ConnectionErrorHandler {
        public void onServerRedirected();

        public void onTimedOut();

        public void onNoInternet();

        public void onServerNotFound();
    }
}

