/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ThrottleableEffectRenderer
extends EffectRenderer {
    public static boolean renderParticles = true;
    public final int limit;
    private final EffectRenderer original;
    private final HashMap<Class, EffectRenderer> delegates = new HashMap();
    private final HashSet<EffectRenderer> delegateSet = new HashSet();
    private boolean isRendering;
    @Deprecated
    private boolean isTicking;
    private ArrayList<ParticleSpawnHandler> particleSpawnHandlers = null;
    private static final ResourceLocation particleTextures = new ResourceLocation("textures/particle/particles.png");
    private static AxisAlignedBB particleBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public ThrottleableEffectRenderer(EffectRenderer eff) {
        super((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71446_o);
        this.limit = Math.max(250, DragonOptions.PARTICLELIMIT.getValue());
        this.original = eff;
    }

    public void registerDelegateRenderer(Class fxClass, EffectRenderer renderer) {
        this.delegates.put(fxClass, renderer);
        this.delegateSet.add(renderer);
    }

    public void addSpawnHandler(ParticleSpawnHandler p) {
        if (this.particleSpawnHandlers == null) {
            this.particleSpawnHandlers = new ArrayList();
        }
        this.particleSpawnHandlers.add(p);
    }

    public void func_78873_a(EntityFX fx) {
        EffectRenderer eff;
        if (fx == null) {
            throw new IllegalArgumentException("You cannot spawn a null particle! This is a bug in the mod calling this code!");
        }
        if (this.particleSpawnHandlers != null) {
            for (ParticleSpawnHandler p : this.particleSpawnHandlers) {
                if (!p.cancel(fx)) continue;
                return;
            }
        }
        if ((eff = this.delegates.get(fx.getClass())) != null) {
            eff.func_78873_a(fx);
            return;
        }
        if (this.isRendering) {
            DragonAPICore.logError("Tried adding a particle mid-render!");
            Thread.dumpStack();
            return;
        }
        int i = fx.func_70537_b();
        if (this.field_78876_b[i].size() >= this.limit) {
            this.field_78876_b[i].remove(0);
        }
        this.field_78876_b[i].add(fx);
    }

    private boolean isInWall(EntityFX fx) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)fx.field_70165_t);
        Block b = fx.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)fx.field_70163_u), z = MathHelper.func_76128_c((double)fx.field_70161_v));
        if (b.func_149662_c() && b.func_149686_d() && b.func_149645_b() == 0) {
            double d = 0.4;
            double minX = (double)x + b.func_149704_x() + d;
            double minY = (double)y + b.func_149665_z() + d;
            double minZ = (double)z + b.func_149706_B() + d;
            double maxX = (double)x + b.func_149753_y() - d;
            double maxY = (double)y + b.func_149669_A() - d;
            double maxZ = (double)z + b.func_149693_C() - d;
            if (ReikaMathLibrary.isValueInsideBounds(minX, maxX, fx.field_70165_t) && ReikaMathLibrary.isValueInsideBounds(minY, maxY, fx.field_70163_u) && ReikaMathLibrary.isValueInsideBounds(minZ, maxZ, fx.field_70161_v)) {
                return true;
            }
        }
        return false;
    }

    public void func_78868_a() {
        super.func_78868_a();
        for (EffectRenderer eff : this.delegateSet) {
            eff.func_78868_a();
        }
    }

    public void func_78874_a(Entity e, float ptick) {
        if (renderParticles) {
            if (ThrottleableEffectRenderer.renderThroughWalls()) {
                GL11.glDisable((int)2929);
            }
            this.doRenderParticles(e, ptick);
            for (EffectRenderer eff : this.delegateSet) {
                eff.func_78874_a(e, ptick);
            }
            GL11.glEnable((int)2929);
        }
    }

    private void doRenderParticles(Entity e, float ptick) {
        float f1 = ActiveRenderInfo.field_74588_d;
        float f2 = ActiveRenderInfo.field_74586_f;
        float f3 = ActiveRenderInfo.field_74587_g;
        float f4 = ActiveRenderInfo.field_74596_h;
        float f5 = ActiveRenderInfo.field_74589_e;
        EntityFX.field_70556_an = e.field_70142_S + (e.field_70165_t - e.field_70142_S) * (double)ptick;
        EntityFX.field_70554_ao = e.field_70137_T + (e.field_70163_u - e.field_70137_T) * (double)ptick;
        EntityFX.field_70555_ap = e.field_70136_U + (e.field_70161_v - e.field_70136_U) * (double)ptick;
        this.isRendering = true;
        for (int i = 0; i < 3; ++i) {
            if (this.field_78876_b[i].isEmpty()) continue;
            this.bindTexture(i);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            for (EntityFX fx : this.field_78876_b[i]) {
                if (fx == null || !ThrottleableEffectRenderer.isParticleVisible(fx)) continue;
                v5.func_78380_c(fx.func_70070_b(ptick));
                try {
                    fx.func_70539_a(v5, ptick, f1, f5, f2, f3, f4);
                }
                catch (Throwable throwable) {
                    this.throwCrash(i, fx, throwable);
                }
                if (v5.field_78415_z) continue;
                DragonAPICore.logError("Particle " + fx + " left the tessellator in a bad state, stopped drawing!");
                v5.func_78382_b();
            }
            v5.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
        this.isRendering = false;
    }

    private void bindTexture(int i) {
        switch (i) {
            default: {
                this.field_78877_c.func_110577_a(particleTextures);
                break;
            }
            case 1: {
                this.field_78877_c.func_110577_a(TextureMap.field_110575_b);
                break;
            }
            case 2: {
                this.field_78877_c.func_110577_a(TextureMap.field_110576_c);
            }
        }
    }

    private void throwCrash(final int i, final EntityFX fx, Throwable throwable) {
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
        crashreportcategory.func_71500_a("Particle", new Callable(){
            private static final String __OBFID = "CL_00000918";

            public String call() {
                return fx.toString();
            }
        });
        crashreportcategory.func_71500_a("Particle Type", new Callable(){
            private static final String __OBFID = "CL_00000919";

            public String call() {
                return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 2 ? "ITEM_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i)));
            }
        });
        throw new ReportedException(crashreport);
    }

    public void func_78872_b(Entity e, float ptick) {
        super.func_78872_b(e, ptick);
        for (EffectRenderer eff : this.delegateSet) {
            eff.func_78872_b(e, ptick);
        }
    }

    public void func_78870_a(World world) {
        super.func_78870_a(world);
        for (EffectRenderer eff : this.delegateSet) {
            eff.func_78870_a(world);
        }
    }

    public String func_78869_b() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.func_78869_b());
        for (EffectRenderer eff : this.delegateSet) {
            sb.append("; ");
            sb.append(eff.func_78869_b());
        }
        return sb.toString();
    }

    public int getParticleCount() {
        int base = 0;
        for (List fx : this.field_78876_b) {
            base += fx.size();
        }
        for (EffectRenderer eff : this.delegateSet) {
            if (!(eff instanceof CustomEffectRenderer)) continue;
            base += ((CustomEffectRenderer)eff).getParticleCount();
        }
        return base;
    }

    public static ThrottleableEffectRenderer getRegisteredInstance() {
        return (ThrottleableEffectRenderer)Minecraft.func_71410_x().field_71452_i;
    }

    public static boolean renderThroughWalls() {
        return Keyboard.isKeyDown((int)210);
    }

    public static boolean isParticleVisible(EntityFX fx) {
        return ReikaRenderHelper.renderFrustrum.func_78546_a(ThrottleableEffectRenderer.getBoundingBox(fx));
    }

    public static AxisAlignedBB getBoundingBox(EntityFX fx) {
        return particleBox.func_72324_b(fx.field_70165_t - (double)fx.field_70544_f, fx.field_70163_u - (double)fx.field_70544_f, fx.field_70161_v - (double)fx.field_70544_f, fx.field_70165_t + (double)fx.field_70544_f, fx.field_70163_u + (double)fx.field_70544_f, fx.field_70161_v + (double)fx.field_70544_f);
    }

    public static interface ParticleSpawnHandler {
        public boolean cancel(EntityFX var1);
    }

    public static interface CustomEffectRenderer {
        public int getParticleCount();
    }
}

