/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Exception;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.DragonAPIException;
import Reika.DragonAPI.ModList;

public class ModIncompatibilityException
extends DragonAPIException {
    public ModIncompatibilityException(DragonAPIMod mod, String otherModName, String msg, boolean fatal) {
        this.message.append(mod.getTechnicalName() + " has compatibility issues with the following mod:\n");
        this.message.append(otherModName + "\n");
        this.message.append("Reason: " + msg + "\n");
        this.message.append("Consult " + mod.getDocumentationSite().toString() + "for details.\n");
        if (fatal) {
            this.message.append("This is a fatal incompatibility. Loading cannot continue.");
            this.crash();
        } else {
            this.message.append("Neither mod may function correctly.");
        }
    }

    public ModIncompatibilityException(ModList mod, ModList otherMod, String msg, boolean fatal) {
        this.message.append(mod.name() + " has compatibility issues with the following mod:\n");
        this.message.append(otherMod.getDisplayName() + "\n");
        this.message.append("Reason: " + msg + "\n");
        this.message.append("Consult the mods' websites for details.\n");
        if (fatal) {
            this.message.append("This is a fatal incompatibility. Loading cannot continue.");
            this.crash();
        } else {
            this.message.append("Neither mod may function correctly.");
        }
    }
}

