/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI;

import Reika.DragonAPI.APIGuiHandler;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.APIProxy;
import Reika.DragonAPI.ASM.DragonAPIClassTransformer;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Auxiliary.DragonAPIEventWatcher;
import Reika.DragonAPI.Auxiliary.DynamicRetrogenSettings;
import Reika.DragonAPI.Auxiliary.LoggingFilters;
import Reika.DragonAPI.Auxiliary.NEI_DragonAPI_Config;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Auxiliary.RainTicker;
import Reika.DragonAPI.Auxiliary.RebootScheduler;
import Reika.DragonAPI.Auxiliary.Trackers.ChunkPregenerator;
import Reika.DragonAPI.Auxiliary.Trackers.CommandableUpdateChecker;
import Reika.DragonAPI.Auxiliary.Trackers.CompatibilityTracker;
import Reika.DragonAPI.Auxiliary.Trackers.CrashNotifications;
import Reika.DragonAPI.Auxiliary.Trackers.EnvironmentSanityChecker;
import Reika.DragonAPI.Auxiliary.Trackers.FurnaceFuelRegistry;
import Reika.DragonAPI.Auxiliary.Trackers.IDCollisionTracker;
import Reika.DragonAPI.Auxiliary.Trackers.IntegrityChecker;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Auxiliary.Trackers.PackModificationTracker;
import Reika.DragonAPI.Auxiliary.Trackers.PatreonController;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerChunkTracker;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerHandler;
import Reika.DragonAPI.Auxiliary.Trackers.RemoteAssetLoader;
import Reika.DragonAPI.Auxiliary.Trackers.SuggestedModsTracker;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Auxiliary.Trackers.VanillaIntegrityTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.Command.ClearParticlesCommand;
import Reika.DragonAPI.Command.GetLatencyCommand;
import Reika.DragonAPI.Command.ToggleBlockChangePacketCommand;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.InvalidBuildException;
import Reika.DragonAPI.Extras.LoginHandler;
import Reika.DragonAPI.Extras.ReplacementCraftingHandler;
import Reika.DragonAPI.Extras.ReplacementSmeltingHandler;
import Reika.DragonAPI.Extras.SanityCheckNotification;
import Reika.DragonAPI.Extras.TemporaryCodeCalls;
import Reika.DragonAPI.Instantiable.EntityTumblingBlock;
import Reika.DragonAPI.Instantiable.Event.Client.SinglePlayerLogoutEvent;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Instantiable.IO.LagWarningFilter;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Instantiable.IO.SyncPacket;
import Reika.DragonAPI.Libraries.IO.ReikaCommandHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import Reika.DragonAPI.ModInteract.BannedItemReader;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.Computers.PeripheralHandlerRelay;
import Reika.DragonAPI.ModInteract.DeepInteract.FrameBlacklist;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModInteract.DeepInteract.MTInteractionManager;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.TwilightForestLootHooks;
import Reika.DragonAPI.ModInteract.ItemHandlers.AppEngHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BCMachineHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BCPipeHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BerryBushHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BloodMagicHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BoPBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.CarpenterBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ChiselBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.DartItemHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.DartOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.FactorizationHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.GalacticCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.GregOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.HarvestCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.HungerOverhaulHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.LegacyMagicCropHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MFRHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicCropHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicaOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekanismHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MimicryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.NaturaBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OpenBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OreBerryBushHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.PneumaticPlantHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.QuantumOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RailcraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RedstoneArsenalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThermalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TransitionalOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.VeryLegacyMagicCropHandler;
import Reika.DragonAPI.ModInteract.MinetweakerHooks;
import Reika.DragonAPI.ModInteract.RecipeHandlers.ForestryRecipeHelper;
import Reika.DragonAPI.ModInteract.RecipeHandlers.SmelteryRecipeHandler;
import Reika.DragonAPI.ModInteract.WailaTechnicalOverride;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="DragonAPI", version="v24c", certificateFingerprint="32:F5:F4:E8:44:C0:EA:C8:6F:46:8A:8E:F3:05:05:7B:6F:90:0F:78", dependencies="required-after:Forge@[10.13.4.1558,);after:BuildCraft|Energy;after:IC2;after:ThermalExpansion;after:Thaumcraft;after:powersuits;after:GalacticCraft;after:Mystcraft;after:UniversalElectricity;after:Forestry;after:MagicBees;after:ExtraBees;after:Natura;after:TConstruct;after:ProjRed|Core;after:bluepower;after:Waila;after:funkylocomotion;after:chisel;after:ComputerCraft;after:ThermalFoundation;after:CarpentersBlocks;after:AgriCraft;after:MineFactoryReloaded")
public class DragonAPIInit
extends DragonAPIMod {
    public static final String packetChannel = "DragonAPIData";
    @SidedProxy(clientSide="Reika.DragonAPI.APIProxyClient", serverSide="Reika.DragonAPI.APIProxy")
    public static APIProxy proxy;
    @Mod.Instance(value="DragonAPI")
    public static DragonAPIInit instance;
    public static final ControlledConfig config;
    private static ModLogger logger;

    @Mod.EventHandler
    public void invalidSignature(FMLFingerprintViolationEvent evt) {
        if (!ReikaObfuscationHelper.isDeObfEnvironment() && !evt.fingerprints.contains(evt.expectedFingerprint.toLowerCase(Locale.ENGLISH).replaceAll(":", ""))) {
            throw new InvalidBuildException(this, evt.source, "Invalid mod jarsign fingerprint!");
        }
    }

    @Override
    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent evt) {
        int val;
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.PRELOAD);
        this.verifyInstallation();
        config.loadSubfolderedConfigFile(evt);
        config.initProps(evt);
        logger = new ModLogger(instance, false);
        if (DragonOptions.FILELOG.getState()) {
            logger.setOutput("**_Loading_Log.log");
        }
        if ((val = DragonOptions.LAGWARNING.getValue()) > 0) {
            LoggingFilters.registerFilter(new LagWarningFilter(val), LoggingFilters.LoggerType.SERVER);
            logger.log("Preparing to filter unneeded and/or trivial 'can't keep up' server log messages with delays of less than " + val + " ms.");
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)DragonAPICore.DragonAPILoadWatcher.instance);
        }
        MinecraftForge.EVENT_BUS.register((Object)DragonAPIEventWatcher.instance);
        logger.log("Initializing libraries with max recursion depth of " + this.getRecursionDepth());
        proxy.registerSidedHandlers();
        this.registerTechnicalBlocks();
        ChunkManager.instance.register();
        DragonOptions.getCollectKey();
        this.initalizeVanillaOreDict();
        ReikaJavaLibrary.initClass(ModList.class);
        this.increasePotionCount();
        this.increaseChunkCap();
        if (ReikaObfuscationHelper.isDeObfEnvironment()) {
            TemporaryCodeCalls.preload(evt);
        }
        this.basicSetup(evt);
        ReikaPacketHelper.registerPacketHandler(instance, packetChannel, new APIPacketHandler());
        int id = DragonOptions.SYNCPACKET.getValue();
        ReikaPacketHelper.registerVanillaPacketType(this, id, SyncPacket.class, Side.SERVER, EnumConnectionState.PLAY);
        if (!DragonOptions.CHECKSANITY.getState()) {
            CrashNotifications.instance.addNotification(null, new SanityCheckNotification());
        }
        this.finishTiming();
    }

    @Override
    protected void postPreLoad() {
        this.rebuildAndRegisterVanillaRecipes();
        BannedItemReader.instance.initWith(BannedItemReader.PLUGIN_PATH + "/BanItem", "*");
        BannedItemReader.instance.initWith(BannedItemReader.PLUGIN_PATH + "/ItemBan", "*");
        BannedItemReader.instance.initWith(BannedItemReader.PLUGIN_PATH + "/TekkitCustomizerData", "*");
        BannedItemReader.instance.initWith(BannedItemReader.PLUGIN_PATH + "/TekkitCustomizer", "*");
        BannedItemReader.instance.initWith(DragonAPICore.getServerRootFolder(), "ItemBlacklist.json");
        BannedItemReader.instance.initWith(Loader.instance().getConfigDir().getAbsolutePath(), "ItemBlacklist.json");
    }

    private void rebuildAndRegisterVanillaRecipes() {
        ReplacementCraftingHandler.fireEventsForVanillaRecipes();
        ReplacementSmeltingHandler.fireEventsForVanillaRecipes();
    }

    private int getRecursionDepth() {
        int config = ReikaJVMParser.getArgumentInteger("-DragonAPI_RecursionLimit");
        if (config == -1) {
            config = 0;
        }
        int min = 500;
        int max = 50000;
        if (config < min && config != 0) {
            logger.logError("Specified recursion limit of " + config + " is far too low, and has been clamped to " + min + ".");
            config = min;
        }
        if (config > max && config != 0) {
            logger.logError("Specified recursion limit of " + config + " is far too high, and has been clamped to " + max + ".");
            config = max;
        }
        return config > 0 ? config : ReikaJavaLibrary.getMaximumRecursiveDepth();
    }

    private void initalizeVanillaOreDict() {
        OreDictionary.registerOre((String)"netherrack", (Block)Blocks.field_150424_aL);
        OreDictionary.registerOre((String)"soulsand", (Block)Blocks.field_150425_aM);
        OreDictionary.registerOre((String)"flower", (Block)Blocks.field_150327_N);
        for (int i = 0; i < BlockFlower.field_149859_a.length; ++i) {
            OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack((Block)Blocks.field_150328_O, 1, i));
        }
    }

    private void increaseChunkCap() {
        Configuration cfg = ForgeChunkManager.getConfig();
        Property modTC = cfg.get(this.getModContainer().getModId(), "maximumTicketCount", 1000);
        Property modCPT = cfg.get(this.getModContainer().getModId(), "maximumChunksPerTicket", 2000);
        cfg.save();
    }

    private void registerTechnicalBlocks() {
        Object[] technicalBlocks = new Block[]{Blocks.field_150382_bo, Blocks.field_150324_C, Blocks.field_150388_bm, Blocks.field_150383_bp, Blocks.field_150457_bL, Blocks.field_150464_aj, Blocks.field_150436_aH, Blocks.field_150414_aQ, Blocks.field_150465_bP, Blocks.field_150332_K, Blocks.field_150439_ay, Blocks.field_150416_aS, Blocks.field_150393_bb, Blocks.field_150472_an, Blocks.field_150455_bV, Blocks.field_150473_bD, Blocks.field_150374_bv, Blocks.field_150394_bc, Blocks.field_150437_az, Blocks.field_150441_bU, Blocks.field_150488_af, Blocks.field_150444_as, Blocks.field_150413_aR, Blocks.field_150454_av, Blocks.field_150466_ao};
        for (int i = 0; i < technicalBlocks.length; ++i) {
            Block b = technicalBlocks[i];
            ItemBlock ib = new ItemBlock(b);
            String s = Block.field_149771_c.func_148750_c((Object)b) + "_technical";
            Item.field_150901_e.func_148756_a(Block.func_149682_b((Block)b), s, (Object)ib);
            if (ModList.WAILA.isLoaded()) {
                WailaTechnicalOverride.instance.addBlock(b);
            }
            if (!ModList.NEI.isLoaded()) continue;
            NEI_DragonAPI_Config.hideBlock(b);
        }
        DragonAPICore.log("Added technical blocks for " + Arrays.toString(technicalBlocks));
        DragonAPICore.log("Note that if you remove DragonAPI, you will need to install the patch from Reika's website for the first launch afterwards.");
    }

    private void increasePotionCount() {
        int count = Potion.field_76425_a.length;
        int newsize = 256;
        if (count > newsize) {
            logger.log("Did not increase potion size array, as some other mod already did.");
            return;
        }
        Potion[] newPotions = new Potion[newsize];
        System.arraycopy(Potion.field_76425_a, 0, newPotions, 0, count);
        Potion.field_76425_a = newPotions;
        if (Potion.field_76425_a.length == newsize) {
            logger.log("Overriding the vanilla PotionTypes array to allow for potion IDs up to " + (newsize - 1) + " (up from " + (count - 1) + ").");
        } else {
            logger.logError("Could not increase potion ID limit from " + count + " to " + newsize + ", but no exception was thrown!");
        }
    }

    @Override
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.LOAD);
        proxy.registerSidedHandlersMain();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            RemoteAssetLoader.instance.checkAndStartDownloads();
        }
        if (ReikaObfuscationHelper.isDeObfEnvironment()) {
            TemporaryCodeCalls.load(event);
        }
        ReikaRegistryHelper.loadNames();
        PlayerHandler.instance.registerTracker(LoginHandler.instance);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new APIGuiHandler());
        ReikaRegistryHelper.registerModEntity(this, EntityTumblingBlock.class, "Tumbling Block", true, 128);
        BiomeGenBase.field_76771_b.field_76751_G = Math.max(1.0f, BiomeGenBase.field_76771_b.field_76751_G);
        BiomeGenBase.field_150575_M.field_76751_G = Math.max(1.0f, BiomeGenBase.field_150575_M.field_76751_G);
        TickRegistry.instance.registerTickHandler(ProgressiveRecursiveBreaker.instance);
        TickRegistry.instance.registerTickHandler(TickScheduler.instance);
        TickRegistry.instance.registerTickHandler(ChunkPregenerator.instance);
        if (DragonOptions.RAINTICK.getState()) {
            TickRegistry.instance.registerTickHandler(RainTicker.instance);
        }
        if (DragonOptions.AUTOREBOOT.getValue() > 0) {
            TickRegistry.instance.registerTickHandler(RebootScheduler.instance);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            TickRegistry.instance.registerTickHandler(KeyWatcher.KeyTicker.instance);
            TickRegistry.instance.registerTickHandler(new ReikaRenderHelper.RenderTick());
        }
        TickRegistry.instance.registerTickHandler(PlayerChunkTracker.instance);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"Reika.DragonAPI.ModInteract.LegacyWailaHelper.registerObjects");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"Reika.DragonAPI.ModInteract.WailaTechnicalOverride.registerOverride");
        FMLInterModComms.sendMessage((String)"Mystcraft", (String)"API", (String)"Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper.receiveAPI");
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"https://sites.google.com/site/reikasminecraft/support-me");
        if (DragonOptions.UNNERFOBSIDIAN.getState()) {
            Blocks.field_150343_Z.func_149752_b(2000.0f);
        }
        if (ModList.COMPUTERCRAFT.isLoaded()) {
            PeripheralHandlerRelay.registerCCHandler();
        }
        if (ModList.OPENCOMPUTERS.isLoaded() && !DragonOptions.DIRECTOC.getState()) {
            PeripheralHandlerRelay.registerOCHandler();
        }
        PatreonController.instance.registerMod("Reika", "http://server.techjargaming.com/Reika/Donator/patreon_");
        logger.log("Credit to Techjar for hosting the version file and remote asset server.");
        CommandableUpdateChecker.instance.checkAll();
        this.finishTiming();
    }

    @Override
    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent evt) {
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.POSTLOAD);
        if (DragonOptions.CHECKSANITY.getState()) {
            EnvironmentSanityChecker.instance.check();
        }
        PackModificationTracker.instance.loadAll();
        this.loadHandlers();
        this.initFlowerSeedsRegistration();
        if (ReikaObfuscationHelper.isDeObfEnvironment()) {
            TemporaryCodeCalls.postload(evt);
        }
        this.alCompat();
        GameRegistry.registerFuelHandler((IFuelHandler)FurnaceFuelRegistry.instance);
        IDCollisionTracker.instance.check();
        VanillaIntegrityTracker.instance.check();
        CompatibilityTracker.instance.test();
        ReikaPotionHelper.loadBadPotions();
        proxy.postLoad();
        IntegrityChecker.instance.testIntegrity();
        ReikaOreHelper.refreshAll();
        ModOreList.initializeAll();
        SuggestedModsTracker.instance.printConsole();
        ReikaJavaLibrary.initClass(FrameBlacklist.class);
        ReikaJavaLibrary.initClass(ReikaMystcraftHelper.class);
        ReikaJavaLibrary.initClass(ReikaThaumHelper.class);
        ReikaJavaLibrary.initClass(SmelteryRecipeHandler.class);
        ReikaJavaLibrary.initClass(TwilightForestLootHooks.class);
        if (ModList.APPENG.isLoaded()) {
            MESystemReader.registerEffectHandler();
        }
        if (MTInteractionManager.isMTLoaded()) {
            MinetweakerHooks.instance.registerAll();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new ToggleBlockChangePacketCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new GetLatencyCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new ClearParticlesCommand());
        }
        if (DragonOptions.BIOMEFIRE.getState()) {
            BiomeGenBase.field_76769_d.field_76751_G = BiomeGenBase.field_76786_s.field_76751_G;
            BiomeGenBase.field_150575_M.field_76751_G = 1.0f;
            BiomeGenBase.field_76771_b.field_76751_G = 1.0f;
        }
        FluidRegistry.WATER.setBlock(Blocks.field_150355_j);
        this.finishTiming();
    }

    private void initFlowerSeedsRegistration() {
        if (ModList.BOP.isLoaded() && BoPBlockHandler.getInstance().initializedProperly()) {
            int i;
            for (i = 0; i < BoPBlockHandler.flower1Types.length; ++i) {
                OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack(BoPBlockHandler.getInstance().flower1, 1, i));
            }
            for (i = 0; i < BoPBlockHandler.flower2Types.length; ++i) {
                OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack(BoPBlockHandler.getInstance().flower2, 1, i));
            }
        }
        if (ModList.BOTANIA.isLoaded()) {
            Block flower = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"flower");
            Block tallflower1 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower1");
            Block tallflower2 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower2");
            for (int i = 0; i < 16; ++i) {
                Block tall = i >= 8 ? tallflower2 : tallflower1;
                int tallm = i % 8;
                OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack(flower, 1, i));
                OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack(tall, 1, tallm));
            }
        }
        if (ModList.PROJRED.isLoaded()) {
            ItemStack seed;
            Block flower = GameRegistry.findBlock((String)"ProjRed|Exploration", (String)"projectred.exploration.lily");
            if (flower != null) {
                OreDictionary.registerOre((String)"flower", (Block)flower);
            }
            if ((seed = ReikaItemHelper.lookupItem("ProjRed|Exploration:projectred.exploration.lilyseed")) != null) {
                OreDictionary.registerOre((String)"seed", (ItemStack)seed);
            }
        }
        OreDictionary.registerOre((String)"seed", (Item)Items.field_151014_N);
        OreDictionary.registerOre((String)"seed", (Item)Items.field_151080_bb);
        OreDictionary.registerOre((String)"seed", (Item)Items.field_151081_bc);
        OreDictionary.registerOre((String)"seed", (Item)Items.field_151075_bm);
        for (int i = 0; i < ModCropList.cropList.length; ++i) {
            ModCropList mod = ModCropList.cropList[i];
            if (mod.seedID == null) continue;
            OreDictionary.registerOre((String)"seed", (ItemStack)new ItemStack(mod.seedID, 1, mod.seedMeta));
        }
        if (ModList.AGRICRAFT.isLoaded()) {
            ItemStack cseed;
            ItemStack pseed = ReikaItemHelper.lookupItem("AgriCraft:seedPotato");
            if (pseed != null) {
                OreDictionary.registerOre((String)"seed", (ItemStack)pseed);
            }
            if ((cseed = ReikaItemHelper.lookupItem("AgriCraft:seedCarrot")) != null) {
                OreDictionary.registerOre((String)"seed", (ItemStack)cseed);
            }
        }
    }

    private void sortCreativeTabs() {
    }

    @Mod.EventHandler
    public void sortRecipes(FMLLoadCompleteEvent evt) {
        if (ForgeModContainer.shouldSortRecipies) {
            ReplacementCraftingHandler.sortRecipes();
        }
        DynamicRetrogenSettings.instance.loadConfig();
    }

    /*
     * Exception decompiling
     */
    @Mod.EventHandler
    public void registerCommands(FMLServerStartingEvent evt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Mod.EventHandler
    public void printPackData(FMLServerStartedEvent evt) {
        DragonAPICore.log("Server Started.");
        DragonAPICore.log("Total Crafting Recipes: " + CraftingManager.func_77594_a().func_77592_b().size());
        DragonAPICore.log("Dimensions Present: " + Arrays.toString((Object[])DimensionManager.getStaticDimensionIDs()));
        DragonAPICore.log("Mods Present: " + Loader.instance().getActiveModList().size());
        DragonAPICore.log("ASM Transformers Loaded: " + Launch.classLoader.getTransformers().size());
        if (MinecraftServer.func_71276_C() != null) {
            DragonAPICore.log("Commands Loaded: " + ReikaCommandHelper.getCommandList().size());
        }
    }

    private void alCompat() {
        int i;
        logger.log("Repairing compatibility between Alumin(i)um OreDictionary Names.");
        ArrayList al = new ArrayList(OreDictionary.getOres((String)"ingotNaturalAluminum"));
        for (i = 0; i < al.size(); ++i) {
            if (!ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"ingotAluminum"), (ItemStack)al.get(i))) {
                OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)((ItemStack)al.get(i)));
            }
            if (ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"ingotAluminium"), (ItemStack)al.get(i))) continue;
            OreDictionary.registerOre((String)"ingotAluminium", (ItemStack)((ItemStack)al.get(i)));
        }
        al = new ArrayList(OreDictionary.getOres((String)"ingotAluminum"));
        for (i = 0; i < al.size(); ++i) {
            if (!ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"ingotNaturalAluminum"), (ItemStack)al.get(i))) {
                OreDictionary.registerOre((String)"ingotNaturalAluminum", (ItemStack)((ItemStack)al.get(i)));
            }
            if (ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"ingotAluminium"), (ItemStack)al.get(i))) continue;
            OreDictionary.registerOre((String)"ingotAluminium", (ItemStack)((ItemStack)al.get(i)));
        }
        al = new ArrayList(OreDictionary.getOres((String)"ingotAluminium"));
        for (i = 0; i < al.size(); ++i) {
            if (!ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"ingotNaturalAluminum"), (ItemStack)al.get(i))) {
                OreDictionary.registerOre((String)"ingotNaturalAluminum", (ItemStack)((ItemStack)al.get(i)));
            }
            if (ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"ingotAluminum"), (ItemStack)al.get(i))) continue;
            OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)((ItemStack)al.get(i)));
        }
        al = new ArrayList(OreDictionary.getOres((String)"oreAluminium"));
        for (i = 0; i < al.size(); ++i) {
            if (ReikaItemHelper.collectionContainsItemStack(OreDictionary.getOres((String)"oreAluminum"), (ItemStack)al.get(i))) continue;
            OreDictionary.registerOre((String)"oreAluminum", (ItemStack)((ItemStack)al.get(i)));
        }
    }

    private void loadHandlers() {
        this.registerHandler(ModList.BCFACTORY, BCMachineHandler.class, "Block Handler");
        this.registerHandler(ModList.BCTRANSPORT, BCPipeHandler.class, "Pipe Handler");
        this.registerHandler(ModList.THAUMCRAFT, ThaumOreHandler.class, "Ore Handler");
        this.registerHandler(ModList.THAUMCRAFT, ThaumIDHandler.class, "Biome Handler");
        this.registerHandler(ModList.DARTCRAFT, DartOreHandler.class, "Ore Handler");
        this.registerHandler(ModList.DARTCRAFT, DartItemHandler.class, "Item Handler");
        this.registerHandler(ModList.TINKERER, TinkerToolHandler.class, "Tool Handler");
        this.registerHandler(ModList.TINKERER, TinkerBlockHandler.class, "Block Handler");
        this.registerHandler(ModList.TWILIGHT, TwilightForestHandler.class, "Handler");
        this.registerHandler(ModList.MEKANISM, MekanismHandler.class, "Block Handler");
        this.registerHandler(ModList.MEKTOOLS, MekToolHandler.class, "Tool Handler");
        this.registerHandler(ModList.TRANSITIONAL, TransitionalOreHandler.class, "Handler");
        this.registerHandler(ModList.IC2, IC2Handler.class, "Handler");
        this.registerHandler(ModList.ARSMAGICA, MagicaOreHandler.class, "Ore Handler");
        this.registerHandler(ModList.APPENG, AppEngHandler.class, "Handler");
        this.registerHandler(ModList.FORESTRY, ForestryHandler.class, "Item Handler");
        this.registerHandler(ModList.FORESTRY, ForestryRecipeHelper.class, "Recipe Handler");
        this.registerHandler(ModList.THERMALFOUNDATION, ThermalHandler.class, "Handler");
        this.registerHandler(ModList.MIMICRY, MimicryHandler.class, "Handler");
        this.registerHandler(ModList.MAGICCROPS, MagicCropHandler.class, "Handler", new ModHandlerBase.SearchVersionHandler("4.0.0_PUBLIC_BETA"));
        this.registerHandler(ModList.MAGICCROPS, LegacyMagicCropHandler.class, "Handler", new ModHandlerBase.SearchVersionHandler("4.0.0_BETA"));
        this.registerHandler(ModList.MAGICCROPS, VeryLegacyMagicCropHandler.class, "Handler", new ModHandlerBase.SearchVersionHandler("1.7.2 - 0.1 ALPHA"));
        this.registerHandler(ModList.QCRAFT, QuantumOreHandler.class, "Handler");
        this.registerHandler(ModList.TINKERER, OreBerryBushHandler.class, "Handler");
        this.registerHandler(ModList.NATURA, BerryBushHandler.class, "Handler");
        this.registerHandler(ModList.OPENBLOCKS, OpenBlockHandler.class, "Handler");
        this.registerHandler(ModList.FACTORIZATION, FactorizationHandler.class, "Handler");
        this.registerHandler(ModList.HARVESTCRAFT, HarvestCraftHandler.class, "Handler");
        this.registerHandler(ModList.ARSENAL, RedstoneArsenalHandler.class, "Handler");
        this.registerHandler(ModList.RAILCRAFT, RailcraftHandler.class, "Handler");
        this.registerHandler(ModList.MINEFACTORY, MFRHandler.class, "Handler");
        this.registerHandler(ModList.GALACTICRAFT, GalacticCraftHandler.class, "Handler");
        this.registerHandler(ModList.EXTRAUTILS, ExtraUtilsHandler.class, "Handler");
        this.registerHandler(ModList.MYSTCRAFT, MystCraftHandler.class, "Block Handler");
        this.registerHandler(ModList.BLOODMAGIC, BloodMagicHandler.class, "Handler");
        this.registerHandler(ModList.PNEUMATICRAFT, PneumaticPlantHandler.class, "Handler");
        this.registerHandler(ModList.BOP, BoPBlockHandler.class, "Handler");
        this.registerHandler(ModList.HUNGEROVERHAUL, HungerOverhaulHandler.class, "Handler");
        this.registerHandler(ModList.CARPENTER, CarpenterBlockHandler.class, "Handler");
        this.registerHandler(ModList.CHISEL, ChiselBlockHandler.class, "Handler");
        this.registerHandler(ModList.GREGTECH, GregOreHandler.class, "Ore Handler");
        this.registerHandler(ModList.NATURA, NaturaBlockHandler.class, "Block Handler");
        ReikaJavaLibrary.initClass(ModOreList.class);
        ReikaJavaLibrary.initClass(ModWoodList.class);
        ReikaJavaLibrary.initClass(ModCropList.class);
        ReikaJavaLibrary.initClass(PowerTypes.class);
        ReikaJavaLibrary.initClass(InterfaceCache.class);
    }

    @Mod.EventHandler
    public void lastLoad(FMLServerAboutToStartEvent evt) {
        ReikaOreHelper.refreshAll();
        ModOreList.initializeAll();
        ReplacementSmeltingHandler.build();
        ReikaDyeHelper.buildItemCache();
        if (ModList.FORESTRY.isLoaded()) {
            ReikaBeeHelper.buildSpeciesList();
        }
    }

    @Mod.EventHandler
    public void singlePlayerLogout(FMLServerStoppedEvent evt) {
        if (evt.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.post((Event)new SinglePlayerLogoutEvent());
        }
    }

    private void registerHandler(ModList mod, Class<? extends ModHandlerBase> c, String id) {
        this.registerHandler(mod, c, id, new ModHandlerBase.VersionIgnore());
    }

    private void registerHandler(ModList mod, Class<? extends ModHandlerBase> c, String id, ModHandlerBase.VersionHandler vh) {
        block6: {
            if (mod.isLoaded()) {
                try {
                    String ver = mod.getVersion();
                    if (vh.acceptVersion(ver)) {
                        this.initHandler(mod, c, id);
                        logger.log("Loading handler " + c + " for mod " + mod + " " + ver + ".");
                        break block6;
                    }
                    logger.log("Not loading handler " + c + " for " + mod.getDisplayName() + "; Version " + ver + " not compatible with " + vh.toString() + ".");
                }
                catch (Exception e) {
                    logger.logError("Could not load handler for " + mod.name());
                    e.printStackTrace();
                }
                catch (LinkageError e) {
                    logger.logError("Class version mismatch error! Could not load handler for " + mod.name());
                    e.printStackTrace();
                }
            } else {
                logger.log("Not loading handler for " + mod.getDisplayName() + "; Mod not present.");
            }
        }
    }

    private void initHandler(ModList mod, Class<? extends ModHandlerBase> c, String id) throws Exception {
        ReikaJavaLibrary.initClass(c);
        Method inst = c.getMethod("getInstance", null);
        ModHandlerBase h = (ModHandlerBase)inst.invoke(null, new Object[0]);
        mod.registerHandler(h, id);
    }

    public static boolean canLoadHandlers() {
        return Loader.instance().hasReachedState(LoaderState.INITIALIZATION);
    }

    @Override
    public String getDisplayName() {
        return "DragonAPI";
    }

    @Override
    public String getModAuthorName() {
        return "Reika";
    }

    @Override
    public URL getDocumentationSite() {
        return DragonAPICore.getReikaForumPage();
    }

    @Override
    public String getWiki() {
        return null;
    }

    @Override
    public String getUpdateCheckURL() {
        return "http://server.techjargaming.com/Reika/versions";
    }

    @Override
    public ModLogger getModLogger() {
        return logger;
    }

    @Override
    public File getConfigFolder() {
        return config.getConfigFolder();
    }

    @Override
    protected Class<? extends IClassTransformer> getASMClass() {
        return DragonAPIClassTransformer.class;
    }

    private static void loadLogParsers() {
        LoggingFilters.registerCoreFilters();
    }

    static {
        instance = new DragonAPIInit();
        config = new ControlledConfig(instance, DragonOptions.optionList, null);
        DragonAPIInit.loadLogParsers();
    }
}

