/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ClearItemsCommand
extends DragonCommandBase {
    private static long clearTime = -1L;
    private static boolean clearAll = false;
    private static final Collection<Integer> clearIDs = new HashSet<Integer>();

    public void func_71515_b(ICommandSender ics, String[] args) {
        clearIDs.clear();
        clearAll = false;
        if (args.length == 0 || args.length == 1 && args[0].toLowerCase(Locale.ENGLISH).equals("scan")) {
            ClearItemsCommand.sendChatToSender(ics, EnumChatFormatting.RED.toString() + "You must specify at least one ID, or a '*'!");
            return;
        }
        boolean scan = false;
        if (args[0].toLowerCase(Locale.ENGLISH).equals("scan")) {
            scan = true;
            String[] cp = new String[args.length - 1];
            System.arraycopy(args, 1, cp, 0, cp.length);
            args = cp;
        }
        if (!scan) {
            clearTime = System.currentTimeMillis();
        }
        this.parseArgs(ics, args, scan);
    }

    private void parseArgs(ICommandSender ics, String[] args, boolean scan) {
        if (args[0].equals("*")) {
            if (scan) {
                this.scanItems(null);
            } else {
                clearAll = true;
            }
            ClearItemsCommand.sendChatToSender(ics, EnumChatFormatting.GREEN.toString() + "Cleared all dropped items.");
        } else {
            if (scan) {
                HashSet<KeyedItemStack> set = new HashSet<KeyedItemStack>();
                for (int i = 0; i < args.length; ++i) {
                    int id = Integer.parseInt(args[i]);
                    Item item = Item.func_150899_d((int)id);
                    KeyedItemStack ks = new KeyedItemStack(new ItemStack(item)).setIgnoreMetadata(true).setIgnoreNBT(true).setSized(false);
                    set.add(ks);
                }
                this.scanItems(new ReikaEntityHelper.MultiItemSelector(set));
            } else {
                for (int i = 0; i < args.length; ++i) {
                    clearIDs.add(Integer.parseInt(args[i]));
                }
            }
            ClearItemsCommand.sendChatToSender(ics, EnumChatFormatting.GREEN.toString() + "Cleared all items with IDs '" + Arrays.toString(args) + "'.");
        }
    }

    private void scanItems(IEntitySelector sel) {
        WorldServer[] worlds;
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            ReikaEntityHelper.clearEntities((World)world, sel);
        }
    }

    @Override
    public String getCommandString() {
        return "clearitems";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    public static boolean clearItem(EntityItem ei) {
        return System.currentTimeMillis() - clearTime < 1000L && (clearAll || clearIDs.contains(Item.func_150891_b((Item)ei.func_92059_d().func_77973_b())));
    }
}

