/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Calendar;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class SpecialDayTracker {
    public static final SpecialDayTracker instance = new SpecialDayTracker();
    private final Calendar calendar;
    private final SimplexNoiseGenerator weatherNoise = new SimplexNoiseGenerator(System.currentTimeMillis());

    private SpecialDayTracker() {
        this.calendar = Calendar.getInstance();
    }

    public boolean loadAprilTextures() {
        if (!DragonOptions.APRIL.getState()) {
            return false;
        }
        return this.calendar.get(2) == 3 && this.calendar.get(5) <= 2;
    }

    public boolean loadXmasTextures() {
        return this.calendar.get(2) == 11 && this.calendar.get(5) >= 18 || this.calendar.get(2) == 0 && this.calendar.get(5) <= 5;
    }

    public float getXmasWeatherStrength(World world) {
        if (!this.loadXmasTextures()) {
            return 0.0f;
        }
        double val = this.weatherNoise.getValue((double)world.func_82737_E() / 6000.0, world.field_73011_w.field_76574_g * 200);
        float norm = (float)Math.sqrt(ReikaMathLibrary.normalizeToBounds(val, 0.0, 1.0));
        return MathHelper.func_76131_a((float)(norm * 1.1f), (float)0.0f, (float)1.0f);
    }

    public boolean isHalloween() {
        return this.calendar.get(2) == 9 && this.calendar.get(5) >= 30;
    }
}

