/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Profiling;

import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ChunkInitProfilingHooks
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (classNode.name.startsWith("net/minecraft/world/gen/") && !classNode.name.equals("net/minecraft/world/gen/ChunkProviderServer") && classNode.interfaces.contains("net/minecraft/world/chunk/IChunkProvider")) {
            ReikaASMHelper.activeMod = "DragonAPI";
            try {
                ReikaASMHelper.activeMod = "DragonAPI";
                MethodNode m = ReikaASMHelper.getMethodByName(classNode, "func_73154_d", "provideChunk", "(II)Lnet/minecraft/world/chunk/Chunk;");
                ArrayList<AbstractInsnNode> c = new ArrayList<AbstractInsnNode>();
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode ain = m.instructions.get(i);
                    if (ain.getOpcode() != 176) continue;
                    c.add(ain);
                }
                this.inject(m, m.instructions.getFirst(), true);
                for (AbstractInsnNode ain : c) {
                    this.inject(m, ain, false);
                }
                ReikaASMHelper.log("Injected " + (c.size() + 1) + " profiling hooks into " + classNode.name);
            }
            catch (ASMException.NoSuchASMMethodException e) {
                ReikaASMHelper.log("Skipping profiling hooks on " + classNode.name + "; does not contain provideChunk method");
            }
        } else {
            return bytes;
        }
        ReikaASMHelper.activeMod = null;
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        classNode.check(classNode.version);
        return writer.toByteArray();
    }

    private void inject(MethodNode m, AbstractInsnNode ain, boolean isPre) {
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new VarInsnNode(21, 1));
        li.add((AbstractInsnNode)new VarInsnNode(21, 2));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Auxiliary/Trackers/WorldgenProfiler", isPre ? "startChunkInit" : "finishChunkInit", "(Lnet/minecraft/world/chunk/IChunkProvider;II)V", false));
        m.instructions.insertBefore(ain, li);
    }
}

