/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.gui;

import covers1624.powerconverters.api.bridge.BridgeSideData;
import covers1624.powerconverters.container.ContainerEnergyBridge;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import covers1624.powerconverters.util.GuiArea;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiEnergyBridge
extends GuiContainer {
    private TileEntityEnergyBridge energyBridge;
    private GuiArea[] guiAreas = new GuiArea[7];

    public GuiEnergyBridge(ContainerEnergyBridge container, TileEntityEnergyBridge te) {
        super((Container)container);
        this.field_147000_g = 195;
        this.energyBridge = te;
    }

    private void initGuiAreas() {
        this.guiAreas[0] = new GuiArea(8, 17, 122, 47, ForgeDirection.UP);
        this.guiAreas[1] = new GuiArea(8, 51, 122, 81, ForgeDirection.NORTH);
        this.guiAreas[2] = new GuiArea(8, 85, 122, 115, ForgeDirection.EAST);
        this.guiAreas[3] = new GuiArea(126, 17, 240, 47, ForgeDirection.DOWN);
        this.guiAreas[4] = new GuiArea(126, 51, 240, 81, ForgeDirection.SOUTH);
        this.guiAreas[5] = new GuiArea(126, 85, 240, 115, ForgeDirection.WEST);
        this.guiAreas[6] = new GuiArea(44, 119, 204, 163, ForgeDirection.UNKNOWN);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawOldGuiContainerForegroundLayer(mouseX, mouseY);
    }

    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("powerconverters:textures/gui/energyBridge.png"));
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawOldGuiContainerBackgroundLayer(gameTicks, mouseX, mouseY, x, y);
    }

    protected void func_73864_a(int mouseX, int mouseY, int clickedButton) {
        super.func_73864_a(mouseX, mouseY, clickedButton);
    }

    private void drawSlotLighting(int mouseX, int mouseY, int x, int y) {
        GL11.glPushMatrix();
        for (GuiArea guiArea : this.guiAreas) {
            if (!guiArea.isMouseInArea(mouseX, mouseY, x, y)) continue;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(guiArea.xTop + x, guiArea.yTop + y, guiArea.xBottom + x, guiArea.yBottom + y, -2130706433, -2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
    }

    private String getOutputRateString(BridgeSideData data) {
        if (!data.isConnected) {
            return "NO LINK";
        }
        double rate = data.outputRate;
        if (rate > 1000.0) {
            double rateThousand = rate / 1000.0;
            return String.format("%.1f %s%s", rateThousand, "k", data.powerSystem.getUnit());
        }
        return rate + " " + data.powerSystem.getUnit();
    }

    private void drawOldGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("Energy Bridge", 8, 6, 0x404040);
        if (this.energyBridge.isInputLimited()) {
            this.field_146289_q.func_78276_b("INPUT LIMITED", 98, 6, -1);
        } else {
            this.field_146289_q.func_78276_b("OUTPUT LIMITED", 90, 6, -1);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            this.field_146289_q.func_78276_b(dir.toString(), 10, 6 + 12 * (i + 1), -1);
            BridgeSideData data = this.energyBridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                String name = data.powerSystem.getAbbreviation();
                if (data.powerSystem.getVoltageNames() != null) {
                    name = name + " " + data.powerSystem.getVoltageNames()[data.voltageNameIndex];
                }
                this.field_146289_q.func_78276_b(name, 49, 6 + 12 * (i + 1), -1);
                this.field_146289_q.func_78276_b(data.isConsumer ? "IN" : "OUT", 92, 6 + 12 * (i + 1), -1);
                this.field_146289_q.func_78276_b(this.getOutputRateString(data), 119, 6 + 12 * (i + 1), -1);
                continue;
            }
            this.field_146289_q.func_78276_b("<NONE>", 49, 6 + 12 * (i + 1), -1);
        }
        this.field_146289_q.func_78276_b("% CHG", 10, 90, -1);
        GL11.glDisable((int)2896);
        GuiEnergyBridge.func_73734_a((int)46, (int)97, (int)(46 + (int)this.energyBridge.getEnergyScaled()), (int)89, (int)-16734721);
        GL11.glEnable((int)2896);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    private void drawOldGuiContainerBackgroundLayer(float gameTicks, int mouseX, int mouseY, int x, int y) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            BridgeSideData data = this.energyBridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                if (!data.isConnected) {
                    this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 208, 162, 12);
                    continue;
                }
                if (data.outputRate == 0.0) {
                    this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 234, 162, 12);
                    continue;
                }
                this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 195, 162, 12);
                continue;
            }
            this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 221, 162, 12);
        }
    }
}

