/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.tcnodetracker.gui;

import com.dyonovan.tcnodetracker.TCNodeTracker;
import com.dyonovan.tcnodetracker.bindings.KeyBindings;
import com.dyonovan.tcnodetracker.gui.GuiConfig;
import com.dyonovan.tcnodetracker.lib.AspectLoc;
import com.dyonovan.tcnodetracker.lib.DimList;
import com.dyonovan.tcnodetracker.lib.JsonUtils;
import com.dyonovan.tcnodetracker.lib.NodeList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMain
extends GuiScreen {
    private static final ResourceLocation nodes = new ResourceLocation("tcnodetracker:textures/gui/nodes.png");
    private static final ResourceLocation smallArrow = new ResourceLocation("tcnodetracker:textures/gui/small_arrows.png");
    public static ArrayList<AspectLoc> aspectList = new ArrayList();
    private int display;
    private int start;
    private int low;
    private int high;
    private int dimID = 0;
    private int dimIndex;
    private String dimName;
    private String currentAspect;
    private String lastSort;

    public void dimFunction() {
        for (int x = 0; x < TCNodeTracker.dims.size(); ++x) {
            if (TCNodeTracker.dims.get((int)x).dimID != this.dimID) continue;
            this.dimName = TCNodeTracker.dims.get((int)x).DimName;
            this.dimIndex = x;
            this.currentAspect = "ALL";
            this.sortNodes("distance");
            return;
        }
    }

    public void func_73866_w_() {
        this.display = 425;
        this.start = (this.field_146294_l - this.display) / 2;
        this.lastSort = "distance";
        TCNodeTracker.dims.clear();
        Integer[] arr$ = DimensionManager.getStaticDimensionIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            if (DimensionManager.getWorld((int)i) != null) {
                try {
                    WorldProvider provider = DimensionManager.getProvider((int)i);
                    TCNodeTracker.dims.add(new DimList(i, provider.func_80007_l()));
                }
                catch (Throwable t) {
                    TCNodeTracker.dims.add(new DimList(i, Integer.toString(i)));
                }
                continue;
            }
            try {
                TCNodeTracker.dims.add(new DimList(i, DimensionManager.createProviderFor((int)i).func_80007_l()));
                continue;
            }
            catch (Throwable t) {
                TCNodeTracker.dims.add(new DimList(i, Integer.toString(i)));
            }
        }
        Collections.sort(TCNodeTracker.dims, new Comparator<DimList>(){

            @Override
            public int compare(DimList o1, DimList o2) {
                return o1.dimID - o2.dimID;
            }
        });
        this.dimID = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
        this.dimFunction();
        this.guiButtons();
    }

    protected void guiButtons() {
        int x = 67;
        this.field_146292_n.clear();
        for (int j = this.low; j < this.high * 2; j += 2) {
            this.field_146292_n.add(new GuiButton(j, this.start + 400, x, 20, 10, StatCollector.func_74838_a((String)"btn.delete.name")));
            this.field_146292_n.add(new GuiButton(j + 1, this.start + 370, x, 30, 10, StatCollector.func_74838_a((String)"btn.mark.name")));
            x += 14;
        }
        this.field_146292_n.add(new GuiButton(this.field_146292_n.size(), this.start + 350, 5, 70, 20, StatCollector.func_74838_a((String)"btn.cleararrow.name")));
        this.field_146292_n.add(new GuiButton(this.field_146292_n.size(), this.start + 350, 27, 70, 20, StatCollector.func_74838_a((String)"btn.config.name")));
        this.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.field_146292_n.size() - 2) {
            TCNodeTracker.doGui = false;
            TCNodeTracker.yMarker = -1;
            this.field_146297_k.func_147108_a(null);
            aspectList.clear();
        } else if (button.field_146127_k == this.field_146292_n.size() - 1) {
            this.field_146297_k.func_147108_a(null);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfig());
        } else if (button.field_146127_k % 2 == 0) {
            int i = button.field_146127_k / 2;
            for (int k = 0; k < TCNodeTracker.nodelist.size(); ++k) {
                for (int j = this.low; j < this.high; ++j) {
                    if (TCNodeTracker.nodelist.get((int)k).x != GuiMain.aspectList.get((int)(this.low + i)).x || TCNodeTracker.nodelist.get((int)k).y != GuiMain.aspectList.get((int)(this.low + i)).y || TCNodeTracker.nodelist.get((int)k).z != GuiMain.aspectList.get((int)(this.low + i)).z) continue;
                    if (TCNodeTracker.doGui && TCNodeTracker.xMarker == GuiMain.aspectList.get((int)(this.low + i)).x && TCNodeTracker.yMarker == GuiMain.aspectList.get((int)(this.low + i)).y && TCNodeTracker.zMarker == GuiMain.aspectList.get((int)(this.low + i)).z) {
                        TCNodeTracker.doGui = false;
                        TCNodeTracker.yMarker = -1;
                    }
                    TCNodeTracker.nodelist.remove(k);
                    JsonUtils.writeJson();
                    this.sortNodes(this.lastSort);
                    return;
                }
            }
        } else if (button.field_146127_k % 2 == 1) {
            int i = button.field_146127_k / 2;
            this.field_146297_k.func_147108_a(null);
            TCNodeTracker.doGui = true;
            TCNodeTracker.xMarker = GuiMain.aspectList.get((int)(this.low + i)).x;
            TCNodeTracker.yMarker = GuiMain.aspectList.get((int)(this.low + i)).y;
            TCNodeTracker.zMarker = GuiMain.aspectList.get((int)(this.low + i)).z;
            aspectList.clear();
        }
    }

    protected void func_73869_a(char key, int i) {
        if (i == KeyBindings.aspectMenu.func_151463_i() || i == 1) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(nodes);
        this.func_73729_b((this.field_146294_l - 204) / 2, 1, 0, 0, 204, 35);
        GuiMain.func_73734_a((int)(this.start + 20), (int)210, (int)(this.start + 100), (int)225, (int)-9408400);
    }

    public void func_146286_b(int mouseX, int mouseY, int button) {
        int w = (this.field_146294_l - 204) / 2;
        if (button >= 0) {
            if (mouseX >= w + 2 && mouseX <= w + 32 && mouseY >= 3 && mouseY <= 35) {
                this.currentAspect = "aer";
                this.sortNodes("distance");
            } else if (mouseX >= w + 35 && mouseX <= w + 66 && mouseY >= 3 && mouseY <= 35) {
                this.currentAspect = "aqua";
                this.sortNodes("distance");
            } else if (mouseX >= w + 70 && mouseX <= w + 101 && mouseY >= 3 && mouseY <= 35) {
                this.currentAspect = "ignis";
                this.sortNodes("distance");
            } else if (mouseX >= w + 104 && mouseX <= w + 135 && mouseY >= 3 && mouseY <= 35) {
                this.currentAspect = "ordo";
                this.sortNodes("distance");
            } else if (mouseX >= w + 139 && mouseX <= w + 170 && mouseY >= 3 && mouseY <= 35) {
                this.currentAspect = "perditio";
                this.sortNodes("distance");
            } else if (mouseX >= w + 172 && mouseX <= w + 203 && mouseY >= 3 && mouseY <= 35) {
                this.currentAspect = "terra";
                this.sortNodes("distance");
            } else if (mouseX >= (this.field_146294_l - 50) / 2 && mouseX <= (this.field_146294_l - 50) / 2 + 15 && mouseY >= 210 && mouseY <= 227 && this.low > 0) {
                --this.low;
                --this.high;
            } else if (mouseX >= (this.field_146294_l + 32) / 2 && mouseX <= (this.field_146294_l + 32) / 2 + 17 && mouseY >= 210 && mouseY <= 227 && this.high != aspectList.size()) {
                ++this.low;
                ++this.high;
            } else if (mouseX >= this.start && mouseX <= this.start + 17 && mouseY >= 209 && mouseY <= 226) {
                this.dimIndex = this.dimIndex == 0 ? TCNodeTracker.dims.size() - 1 : --this.dimIndex;
                this.dimID = TCNodeTracker.dims.get((int)this.dimIndex).dimID;
                this.dimFunction();
            } else if (mouseX >= this.start + 102 && mouseX <= this.start + 119 && mouseY >= 209 && mouseY <= 226) {
                this.dimIndex = this.dimIndex < TCNodeTracker.dims.size() - 1 ? ++this.dimIndex : 0;
                this.dimID = TCNodeTracker.dims.get((int)this.dimIndex).dimID;
                this.dimFunction();
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 2, 55, this.start + 20, 65)) {
                this.sortNodes("distance");
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 188, 55, this.start + 208, 65)) {
                this.sortNodes("aer");
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 214, 55, this.start + 238, 65)) {
                this.sortNodes("aqua");
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 246, 55, this.start + 270, 65)) {
                this.sortNodes("ignis");
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 278, 55, this.start + 302, 65)) {
                this.sortNodes("ordo");
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 310, 55, this.start + 334, 65)) {
                this.sortNodes("perditio");
            } else if (GuiMain.isInBounds(mouseX, mouseY, this.start + 342, 55, this.start + 372, 65)) {
                this.sortNodes("terra");
            }
        }
    }

    private void sortNodes(String sortBy) {
        Comparator<AspectLoc> comparator;
        aspectList.clear();
        this.lastSort = sortBy;
        for (NodeList n : TCNodeTracker.nodelist) {
            if (this.currentAspect.equals("ALL") && n.dim == this.dimID) {
                this.getNodes(n);
                continue;
            }
            if (!n.aspect.containsKey(this.currentAspect) || n.dim != this.dimID) continue;
            this.getNodes(n);
        }
        switch (sortBy) {
            case "distance": {
                comparator = AspectLoc.getDistComparator();
                break;
            }
            case "aer": {
                comparator = AspectLoc.getAerComparator();
                break;
            }
            case "aqua": {
                comparator = AspectLoc.getAquaComparator();
                break;
            }
            case "ignis": {
                comparator = AspectLoc.getIgnisComparator();
                break;
            }
            case "ordo": {
                comparator = AspectLoc.getOrdoComparator();
                break;
            }
            case "perditio": {
                comparator = AspectLoc.getPerdComparator();
                break;
            }
            case "terra": {
                comparator = AspectLoc.getTerraComparator();
                break;
            }
            default: {
                comparator = AspectLoc.getDistComparator();
            }
        }
        Collections.sort(aspectList, comparator);
        if (!sortBy.equals("distance")) {
            Collections.reverse(aspectList);
        }
        this.low = 0;
        this.high = aspectList.size() > 10 ? 10 : aspectList.size();
        this.guiButtons();
    }

    private void getNodes(NodeList nodes) {
        int air = 0;
        int water = 0;
        int fire = 0;
        int order = 0;
        int entropy = 0;
        int earth = 0;
        HashMap<String, Integer> compound = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> node : nodes.aspect.entrySet()) {
            String aspect = node.getKey();
            int amount = node.getValue();
            if (aspect.equalsIgnoreCase("aer")) {
                air += amount;
                continue;
            }
            if (aspect.equalsIgnoreCase("aqua")) {
                water += amount;
                continue;
            }
            if (aspect.equalsIgnoreCase("ignis")) {
                fire += amount;
                continue;
            }
            if (aspect.equalsIgnoreCase("ordo")) {
                order += amount;
                continue;
            }
            if (aspect.equalsIgnoreCase("perditio")) {
                entropy += amount;
                continue;
            }
            if (aspect.equalsIgnoreCase("terra")) {
                earth += amount;
                continue;
            }
            compound.put(aspect, amount);
        }
        aspectList.add(new AspectLoc(nodes.x, nodes.y, nodes.z, nodes.dim, nodes.date, (int)Math.round(this.field_146297_k.field_71439_g.func_70011_f((double)nodes.x, this.field_146297_k.field_71439_g.field_70163_u, (double)nodes.z)), nodes.type, nodes.mod, air, water, fire, order, entropy, earth, compound));
    }

    public void func_73863_a(int x, int y, float f) {
        int l = 70;
        this.func_146276_q_();
        this.field_146289_q.func_78276_b(this.dimName, this.start + 20 + (80 - this.field_146289_q.func_78256_a(this.dimName)) / 2, 214, 0xFFFFFF);
        String s1 = StatCollector.func_74838_a((String)"str.instruction.name");
        this.field_146289_q.func_78276_b(s1, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(s1) / 2, 40, 0xFFFFFF);
        GuiMain.func_73734_a((int)this.start, (int)50, (int)(this.start + this.display), (int)52, (int)-9408400);
        GuiMain.func_73734_a((int)this.start, (int)64, (int)(this.start + this.display), (int)66, (int)-9408400);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"str.distance.name"), this.start + 2, 55, 0xFFFFFF);
        this.field_146289_q.func_78276_b("X", this.start + 50, 55, 0xFFFFFF);
        this.field_146289_q.func_78276_b("Y", this.start + 80, 55, 0xFFFFFF);
        this.field_146289_q.func_78276_b("Z", this.start + 110, 55, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"str.type.name"), this.start + 130, 55, 0xFFFFFF);
        s1 = "Aer  Aqua  Ignis  Ordo  Perd  Terra";
        this.field_146289_q.func_78276_b(s1, this.start + 178, 55, 0xFFFFFF);
        for (AspectLoc a : aspectList.subList(this.low, this.high)) {
            int color = TCNodeTracker.xMarker == a.x && TCNodeTracker.yMarker == a.y && TCNodeTracker.zMarker == a.z ? 2533936 : 0xFFFFFF;
            String s2 = Integer.toString(a.distance);
            this.field_146289_q.func_78276_b(s2, this.start + (11 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = Integer.toString(a.x);
            this.field_146289_q.func_78276_b(s2, this.start + (52 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = Integer.toString(a.y);
            this.field_146289_q.func_78276_b(s2, this.start + (83 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = Integer.toString(a.z);
            this.field_146289_q.func_78276_b(s2, this.start + (112 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.type.substring(0, 1);
            this.field_146289_q.func_78276_b(s2, this.start + (142 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.hasAer > 0 ? Integer.toString(a.hasAer) : "";
            this.field_146289_q.func_78276_b(s2, this.start + (185 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.hasAqua > 0 ? Integer.toString(a.hasAqua) : "";
            this.field_146289_q.func_78276_b(s2, this.start + (216 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.hasIgnis > 0 ? Integer.toString(a.hasIgnis) : "";
            this.field_146289_q.func_78276_b(s2, this.start + (248 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.hasOrdo > 0 ? Integer.toString(a.hasOrdo) : "";
            this.field_146289_q.func_78276_b(s2, this.start + (280 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.hasPerdito > 0 ? Integer.toString(a.hasPerdito) : "";
            this.field_146289_q.func_78276_b(s2, this.start + (312 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            s2 = a.hasTerra > 0 ? Integer.toString(a.hasTerra) : "";
            this.field_146289_q.func_78276_b(s2, this.start + (348 - this.field_146289_q.func_78256_a(s2) / 2), l, color);
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GuiMain.func_73734_a((int)this.start, (int)(l + 9), (int)(this.start + this.display), (int)(l + 10), (int)-9408400);
            GL11.glPopMatrix();
            l += 14;
        }
        l = 70;
        for (AspectLoc a : aspectList.subList(this.low, this.high)) {
            ArrayList<String> toolTip;
            if (GuiMain.isInBounds(x, y, this.start + 130, l - 5, this.start + 156, l + 8)) {
                toolTip = new ArrayList<String>();
                toolTip.add("\u00a7" + Integer.toHexString(2) + "Compound Aspects:");
                if (a.compound.size() > 0) {
                    for (Map.Entry<String, Integer> node : a.compound.entrySet()) {
                        toolTip.add(node.getKey().toUpperCase() + ": " + node.getValue());
                    }
                } else {
                    toolTip.add("None");
                }
                toolTip.add(StatCollector.func_74838_a((String)("\u00a7" + Integer.toHexString(2) + "Type: " + "\u00a7" + Integer.toHexString(15) + StatCollector.func_74838_a((String)("nodetype." + a.type + ".name")))));
                if (a.mod != null && !a.mod.equals("BLANK")) {
                    toolTip.add("\u00a7" + Integer.toHexString(4) + "State: " + "\u00a7" + Integer.toHexString(15) + StatCollector.func_74838_a((String)("nodemod." + a.mod + ".name")));
                }
                this.drawHoveringText(toolTip, x, y, this.field_146289_q);
            } else if (GuiMain.isInBounds(x, y, this.start + 2, l - 5, this.start + 40, l + 8)) {
                toolTip = new ArrayList();
                toolTip.add("\u00a7" + Integer.toHexString(2) + "Last Scanned");
                if (a.date != null) {
                    toolTip.add(new SimpleDateFormat("HH:mm:ss yyyy.MM.dd").format(a.date));
                } else {
                    toolTip.add("Unknown");
                }
                this.drawHoveringText(toolTip, x, y, this.field_146289_q);
            }
            l += 14;
        }
        this.field_146297_k.func_110434_K().func_110577_a(smallArrow);
        if (this.low > 0) {
            this.func_73729_b((this.field_146294_l - 50) / 2, 210, 1, 1, 15, 17);
        }
        if (this.high != aspectList.size()) {
            this.func_73729_b((this.field_146294_l + 32) / 2, 211, 17, 1, 32, 17);
        }
        this.func_73729_b(this.start, 209, 91, 41, 17, 17);
        this.func_73729_b(this.start + 102, 209, 91, 25, 17, 17);
        super.func_73863_a(x, y, f);
    }

    public static boolean isInBounds(int x, int y, int a, int b, int c, int d) {
        return x >= a && x <= c && y >= b && y <= d;
    }
}

