/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.network.pressure;

import com.cout970.magneticraft.api.pressure.IPressureConductor;
import com.cout970.magneticraft.api.pressure.PressurizedFluid;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.network.NetworkNode;
import com.cout970.magneticraft.util.network.pressure.PressureNetwork;
import com.cout970.magneticraft.util.network.pressure.PressureNetworkNode;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class NetworkPressureConductor
implements IPressureConductor {
    public PressureNetwork network;

    public NetworkPressureConductor(PressureNetwork net) {
        this.network = net;
    }

    @Override
    public TileEntity getParent() {
        return this.network.getStart().getParent();
    }

    @Override
    public void iterate() {
    }

    @Override
    public VecInt[] getValidConnections() {
        return new VecInt[0];
    }

    @Override
    public boolean isAbleToConnect(IConnectable cond, VecInt dir) {
        return false;
    }

    @Override
    public ConnectionClass getConnectionClass(VecInt v) {
        return ConnectionClass.FULL_BLOCK;
    }

    @Override
    public void save(NBTTagCompound nbt) {
    }

    @Override
    public void load(NBTTagCompound nbt) {
    }

    @Override
    public double getVolume() {
        double vol = 0.0;
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            vol += ((PressureNetworkNode)nd).getConductor().getVolumeNode();
        }
        return vol;
    }

    @Override
    public void setVolume(double c) {
    }

    @Override
    public double getPressure() {
        return this.getMoles() * this.getTemperature() * 8.3144621 / (this.getVolume() / 1000.0) * 1000.0;
    }

    @Override
    public double getMaxPressure() {
        double min = 0.0;
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            min = min == 0.0 ? ((PressureNetworkNode)nd).getConductor().getMaxPressure() : Math.min(min, ((PressureNetworkNode)nd).getConductor().getMaxPressure());
        }
        return min;
    }

    @Override
    public double getMoles() {
        double mol = 0.0;
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            mol += ((PressureNetworkNode)nd).getConductor().getMolesNode();
        }
        return mol;
    }

    @Override
    public void setMoles(double moles) {
        double part = moles / (double)this.network.getNodeCount();
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            ((PressureNetworkNode)nd).getConductor().setMolesNode(part);
        }
    }

    @Override
    public double getTemperature() {
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            return ((PressureNetworkNode)nd).getConductor().getTemperatureNode();
        }
        return 0.0;
    }

    @Override
    public void setTemperature(double temp) {
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            ((PressureNetworkNode)nd).getConductor().setTemperatureNode(temp);
        }
    }

    @Override
    public void onBlockExplode() {
    }

    @Override
    public Fluid getFluid() {
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            return ((PressureNetworkNode)nd).getConductor().getFluidNode();
        }
        return null;
    }

    @Override
    public void setFluid(Fluid fluid) {
        for (NetworkNode nd : this.network.getNodes()) {
            if (!(nd instanceof PressureNetworkNode) || ((PressureNetworkNode)nd).getConductor() == null) continue;
            ((PressureNetworkNode)nd).getConductor().setFluidNode(fluid);
        }
    }

    @Override
    public int applyGas(FluidStack gas, boolean doFill) {
        return 0;
    }

    @Override
    public FluidStack drainGas(int amount, boolean doDrain) {
        return null;
    }

    @Override
    public PressurizedFluid moveFluid(PressurizedFluid pack) {
        if (pack.getAmount() < 0.0 || pack.getFluid() == null) {
            return pack;
        }
        this.setFluid(pack.getFluid());
        double total = this.getMoles() + pack.getAmount();
        this.setTemperature(this.getTemperature() * (this.getMoles() / total) + pack.getTemperature() * (pack.getAmount() / total));
        this.setMoles(total);
        return null;
    }
}

