/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class MultilineString {
    public List<OffsetString> strings;

    public MultilineString(String origin) {
        String[] t = origin.split("\\{\\{");
        this.strings = new ArrayList<OffsetString>(t.length);
        for (String s : t) {
            if (s.isEmpty()) continue;
            try {
                String[] split1 = s.split("\\}\\}", 2);
                String[] split2 = split1[0].split(":");
                this.strings.add(new OffsetString(Integer.parseInt(split2[0]), Integer.parseInt(split2[1]), split1[1]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Malformed multi-line: " + origin, e);
            }
        }
    }

    public void drawCentered(GuiScreen gui, FontRenderer fontRenderer, int x, int y, int color) {
        this.strings.forEach(n -> gui.func_73732_a(fontRenderer, n.getBase(), x + n.getXOffset(), y + n.getYOffset(), color));
    }

    public static class OffsetString {
        private final int xOffset;
        private final int yOffset;
        private final String base;

        public OffsetString(int x, int y, String base) {
            this.xOffset = x;
            this.yOffset = y;
            this.base = base;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public String getBase() {
            return this.base;
        }
    }
}

