/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.shelf;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.shelf.TileShelf;
import com.cout970.magneticraft.tileentity.shelf.TileShelfFiller;
import com.cout970.magneticraft.util.InventoryResizable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

public class TileShelvingUnit
extends TileShelf {
    public static final int MAX_CRATES = 24;
    public static final int MAX_SHELVES = 3;
    public static final int CRATE_SIZE = 27;
    public static final int SHELF_CRATES = 8;
    private int crates = 0;
    private InventoryResizable[] rowInv = new InventoryResizable[3];
    private boolean placing;

    public TileShelvingUnit() {
        for (int i = 0; i < 3; ++i) {
            this.rowInv[i] = new InventoryResizable(this, 216, "Shelf " + i);
            this.rowInv[i].lock();
        }
    }

    @Override
    public void func_145845_h() {
        if (this.crates > 16) {
            this.createTopShelf();
        }
    }

    public InventoryResizable getInv(int i) {
        return this.rowInv[i];
    }

    @Override
    public VecInt getOffset() {
        return VecInt.NULL_VECTOR;
    }

    @Override
    public TileShelvingUnit getMainTile() {
        return this;
    }

    public boolean addCrate() {
        if (this.crates < 24) {
            if (this.crates == 16 && !this.createTopShelf()) {
                return false;
            }
            if (this.rowInv[this.crates / 8].resize(27)) {
                ++this.crates;
                return true;
            }
        }
        return false;
    }

    private boolean createTopShelf() {
        ArrayList<VecInt> placeCoords = new ArrayList<VecInt>();
        for (int r = -2; r <= 2; ++r) {
            for (int b = 0; b < 2; ++b) {
                VecInt coord = VecIntUtil.getRotatedOffset(MgDirection.getDirection(this.func_145832_p()), r, 3, b).add(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                Block block = coord.getBlock((IBlockAccess)this.field_145850_b);
                if (block == ManagerBlocks.shelving_unit) continue;
                if (block == null || coord.isBlockReplaceable((IBlockAccess)this.field_145850_b)) {
                    placeCoords.add(coord);
                    continue;
                }
                return false;
            }
        }
        for (VecInt coord : placeCoords) {
            if (coord.blockExists(this.field_145850_b)) continue;
            return false;
        }
        for (VecInt coord : placeCoords) {
            coord.setBlockWithMetadata(this.field_145850_b, ManagerBlocks.shelving_unit, 10, 3);
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileShelfFiller)) {
                tile = new TileShelfFiller();
                coord.setTileEntity(this.field_145850_b, tile);
            }
            ((TileShelfFiller)tile).setOffset(coord.copy().add(-this.field_145851_c, -this.field_145848_d, -this.field_145849_e));
        }
        return true;
    }

    public boolean removeCrate() {
        if (this.crates > 0 && this.rowInv[(this.crates - 1) / 8].resize(-27)) {
            --this.crates;
            if (this.crates == 16) {
                this.clearTopShelf();
            }
            return true;
        }
        return false;
    }

    private void clearTopShelf() {
        for (int r = -2; r <= 2; ++r) {
            for (int b = 0; b < 2; ++b) {
                VecInt coord = VecIntUtil.getRotatedOffset(MgDirection.getDirection(this.func_145832_p()), r, 3, b).add(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (coord.getBlock((IBlockAccess)this.field_145850_b) != ManagerBlocks.shelving_unit || coord.getBlockMetadata((IBlockAccess)this.field_145850_b) != 10) continue;
                ((TileShelfFiller)coord.getTileEntity((IBlockAccess)this.field_145850_b)).silentRemoval = true;
                this.field_145850_b.func_147468_f(coord.getX(), coord.getY(), coord.getZ());
            }
        }
    }

    @Override
    public void onBlockBreaks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (InventoryResizable inv : this.rowInv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                BlockMg.dropItem(inv.func_70301_a(i), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
            }
        }
        if (this.getCrateCount() > 0) {
            BlockMg.dropItem(new ItemStack((Block)Blocks.field_150486_ae, this.getCrateCount()), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    public int getCrateCount() {
        return this.crates;
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v1 = VecIntUtil.getRotatedOffset(MgDirection.getDirection(this.func_145832_p()), -2, 0, 0);
        VecInt v2 = VecIntUtil.getRotatedOffset(MgDirection.getDirection(this.func_145832_p()), 2, 3, 1);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(v1.add(block), v2.add(block));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.crates = nbt.func_74762_e("crates");
        this.placing = nbt.func_74767_n("isPlacing");
        for (int i = 0; i < 3; ++i) {
            this.rowInv[i].readFromNBT(nbt, this.rowInv[i].name);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("crates", this.crates);
        nbt.func_74757_a("isPlacing", this.placing);
        for (int i = 0; i < 3; ++i) {
            this.rowInv[i].writeToNBT(nbt, this.rowInv[i].name);
        }
    }

    public void setPlacing(boolean placing, EntityPlayer p) {
        if (p != null && !this.field_145850_b.field_72995_K) {
            p.func_146105_b((IChatComponent)new ChatComponentText(placing ? "Switched to placement mode" : "Switched to inventory mode"));
        }
        this.placing = placing;
    }

    public boolean isPlacing() {
        return this.placing;
    }
}

