/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.ElectricConstants;
import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IIndexedConnection;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.IndexedConnection;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileDiode
extends TileConductorLow {
    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this, 0.01){

            @Override
            public void recache() {
                if (!this.connected) {
                    this.connected = true;
                    this.con.clear();
                    int sides = 0;
                    for (VecInt f : this.getValidConnections()) {
                        TileEntity target = MgUtils.getTileEntity(this.tile, f);
                        IElectricConductor[] c = ElectricUtils.getElectricCond(target, f.getOpposite(), this.getTier());
                        IEnergyInterface inter = ElectricUtils.getInterface(target, f.getOpposite(), this.getTier());
                        if (c != null) {
                            for (IElectricConductor e : c) {
                                if (e == this || !this.isAbleToConnect(e, f) || !e.isAbleToConnect(this, f.getOpposite())) continue;
                                this.con.add(new IndexedConnection((IElectricConductor)this, f, e, sides));
                                ++sides;
                            }
                        }
                        if (inter == null || !inter.canConnect(f)) continue;
                        this.con.add(new IndexedConnection((IElectricConductor)this, f, inter, sides));
                        ++sides;
                    }
                    if (this.currents == null) {
                        this.currents = new double[sides];
                    } else if (this.currents.length != sides) {
                        double[] temp = new double[sides];
                        System.arraycopy(this.currents, 0, temp, 0, Math.min(sides, this.currents.length));
                        this.currents = temp;
                    }
                }
            }

            @Override
            public void iterate() {
                TileEntity tile = this.getParent();
                World w = tile.func_145831_w();
                if (w.field_72995_K) {
                    return;
                }
                tile.func_70296_d();
                this.getVoltage();
                for (IIndexedConnection f : this.con) {
                    this.valance_diode(f, this.currents);
                }
            }

            public void valance_diode(IIndexedConnection f, double[] currents) {
                double watt;
                IElectricConductor cond = f.getConductor();
                IEnergyInterface c = f.getEnergyInterface();
                if (cond != null) {
                    double resistence = f.getSource().getResistance() + cond.getResistance();
                    double deltaV = f.getSource().getVoltage() - cond.getVoltage();
                    if (Double.isNaN(currents[f.getIndex()])) {
                        currents[f.getIndex()] = 0.0;
                    }
                    if (f.getOffset().equals(TileDiode.this.getDirection().toVecInt()) && deltaV > 0.0 || !f.getOffset().equals(TileDiode.this.getDirection().toVecInt())) {
                        double current = currents[f.getIndex()];
                        double vDiff = deltaV - current * resistence;
                        vDiff = Math.min(vDiff, Math.abs(deltaV));
                        vDiff = Math.max(vDiff, -Math.abs(deltaV));
                        int n = f.getIndex();
                        currents[n] = currents[n] + vDiff * f.getSource().getIndScale() / f.getSource().getVoltageMultiplier();
                        f.getSource().applyCurrent(-(current += deltaV * 0.5 / f.getSource().getVoltageMultiplier()));
                        cond.applyCurrent(current);
                    }
                }
                if (c != null && f.getSource().getVoltage() > 60.0 && c.canAcceptEnergy(f) && (watt = Math.min(c.getMaxFlow(), (f.getSource().getVoltage() - 60.0) * ElectricConstants.CONVERSION_SPEED)) > 0.0) {
                    f.getSource().drainPower(c.applyEnergy(watt));
                }
            }

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileDiode.this.getDirection().toVecInt(), TileDiode.this.getDirection().opposite().toVecInt()};
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.CABLE_LOW;
            }

            @Override
            public boolean canFlowPower(IIndexedConnection con) {
                return false;
            }
        };
    }

    @Override
    public IElectricConductor[] getConds(VecInt dir, int tier) {
        if (tier != 0 && tier != -1) {
            return null;
        }
        if (VecInt.NULL_VECTOR.equals(dir) || this.getDirection().toVecInt().equals(dir) || this.getDirection().opposite().toVecInt().equals(dir)) {
            return new IElectricConductor[]{this.cond};
        }
        return null;
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }
}

