/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import com.cout970.magneticraft.ManagerFluids;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.BufferedConductor;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.IHeatTile;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.block.fluids.BlockFuel;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.compat.ManagerIntegration;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileCombustionEngine
extends TileConductorLow
implements IFluidHandler1_8,
IHeatTile,
IGuiSync {
    private TankMg tank = new TankMg(this, 4000);
    public IHeatConductor heat = new HeatConductor(this, 600.0, 800.0);
    private float buffer;
    private float prod;
    private float counter;
    private int maxProd;
    private int oldHeat;
    BlockFuel fuel;
    IFuel fuelBC;

    public TankMg getTank() {
        return this.tank;
    }

    @Override
    public void func_145845_h() {
        BlockFuel f;
        FluidStack fluid;
        if (ManagerIntegration.BUILDCRAFT) {
            this.updateEntityBC();
            return;
        }
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.heat.iterate();
        if ((int)this.heat.getTemperature() != this.oldHeat && this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.sendUpdateToClient();
            this.oldHeat = (int)this.heat.getTemperature();
        }
        if (this.buffer > 0.0f && this.cond.getVoltage() < 100.0 && this.heat.getTemperature() < 500.0 && this.isControlled() && this.fuel != null) {
            float speed = this.getSpeed();
            double p = EnergyConverter.RFtoW(this.fuel.getPowerPerCycle()) * (double)speed;
            this.buffer -= speed;
            this.counter = (float)((double)this.counter + p);
            this.cond.applyPower(p);
            this.heat.applyCalories(EnergyConverter.RFtoCALORIES(0.2));
        }
        if ((this.buffer <= 0.0f || this.fuel == null && this.getTank().getFluidAmount() >= 10) && (fluid = this.getTank().getFluid()) != null && (f = ManagerFluids.fuels.get(fluid.getFluid())) != null) {
            this.buffer += (float)(f.getTotalBurningTime() / 100);
            this.fuel = f;
            this.maxProd = (int)EnergyConverter.RFtoW(f.getPowerPerCycle());
            this.getTank().drain(10, true);
        }
    }

    public void updateEntityBC() {
        IFuel f;
        FluidStack fluid;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.heat.iterate();
        if ((int)this.heat.getTemperature() != this.oldHeat && this.field_145850_b.field_73011_w.getWorldTime() % 10L == 0L) {
            this.sendUpdateToClient();
            this.oldHeat = (int)this.heat.getTemperature();
        }
        if (this.buffer > 0.0f && this.cond.getVoltage() < 100.0 && this.heat.getTemperature() < 500.0 && this.isControlled() && this.fuelBC != null) {
            float speed = this.getSpeed();
            double p = EnergyConverter.RFtoW(this.fuelBC.getPowerPerCycle()) * (double)speed;
            this.buffer -= speed;
            this.counter = (float)((double)this.counter + p);
            this.cond.applyPower(p);
            this.heat.applyCalories(EnergyConverter.RFtoCALORIES(0.2));
        }
        if ((this.buffer <= 0.0f || this.fuelBC == null && this.getTank().getFluidAmount() >= 10) && (fluid = this.getTank().getFluid()) != null && (f = BuildcraftFuelRegistry.fuel.getFuel(fluid.getFluid())) != null) {
            this.buffer += (float)(f.getTotalBurningTime() / 100);
            this.fuelBC = f;
            this.maxProd = (int)EnergyConverter.RFtoW(f.getPowerPerCycle());
            this.getTank().drain(10, true);
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.prod = this.counter / 20.0f;
            this.counter = 0.0f;
        }
    }

    private float getSpeed() {
        return 1.0f - (float)((int)((this.heat.getTemperature() - 25.0) * (double)0.128f)) / 64.0f;
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        return this.getTank().fill(resource, doFill);
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return this.getTank().drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.getTank().getInfo()};
    }

    @Override
    public IElectricConductor initConductor() {
        return new BufferedConductor(this, 0.01, 80000, 66.66666666666667, 75.0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.buffer = nbt.func_74760_g("Buffer");
        this.getTank().readFromNBT(nbt);
        this.heat.load(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("Buffer", this.buffer);
        this.getTank().writeToNBT(nbt);
        this.heat.save(nbt);
    }

    @Override
    public IHeatConductor[] getHeatCond(VecInt c) {
        return new IHeatConductor[]{this.heat};
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.cond.getStorage() & 0xFFFF);
        craft.func_71112_a(cont, 2, (this.cond.getStorage() & 0xFFFF0000) >>> 16);
        craft.func_71112_a(cont, 3, (int)this.heat.getTemperature());
        if (this.getTank().getFluidAmount() > 0) {
            craft.func_71112_a(cont, 4, this.getTank().getFluid().getFluidID());
            craft.func_71112_a(cont, 5, this.getTank().getFluidAmount());
        } else {
            craft.func_71112_a(cont, 4, -1);
        }
        craft.func_71112_a(cont, 6, (int)this.prod * 100);
        craft.func_71112_a(cont, 7, this.maxProd);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.cond.setStorage(value & 0xFFFF);
        }
        if (id == 2) {
            this.cond.setStorage(this.cond.getStorage() | value << 16);
        }
        if (id == 3) {
            this.heat.setTemperature(value);
        }
        if (id == 4) {
            if (value == -1) {
                this.getTank().setFluid(null);
            } else {
                this.getTank().setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
            }
        }
        if (id == 5) {
            this.getTank().setFluid(new FluidStack(this.getTank().getFluid(), value));
        }
        if (id == 6) {
            this.prod = (float)value / 100.0f;
        }
        if (id == 7) {
            this.maxProd = value;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
    }

    public IBarProvider getProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return "Generating: " + TileCombustionEngine.this.prod + "W";
            }

            @Override
            public float getMaxLevel() {
                return Math.max(TileCombustionEngine.this.maxProd, 1);
            }

            @Override
            public float getLevel() {
                return TileCombustionEngine.this.prod;
            }
        };
    }
}

