/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.tile.TileHeatConductor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class TileBrickFurnace
extends TileHeatConductor
implements IInventoryManaged,
ISidedInventory,
IGuiSync {
    private static final float MAX_PROGRESS = 100.0f;
    private InventoryComponent inv = new InventoryComponent(this, 2, "Brick Furnace");
    private float progress;
    private boolean working;

    @Override
    public IHeatConductor initHeatCond() {
        return new HeatConductor(this, 1400.0, 1000.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.heat.getTemperature() > 80.0 && this.isControlled()) {
            if (this.canSmelt()) {
                double speed = this.getSpeed();
                this.heat.drainCalories(speed);
                this.progress = (float)((double)this.progress + EnergyConverter.CALORIEStoFUEL(speed));
                if (this.progress >= 100.0f) {
                    this.smelt();
                    this.progress -= 100.0f;
                }
                this.working = true;
            } else {
                this.working = false;
                this.progress = 0.0f;
            }
        } else {
            this.working = false;
        }
    }

    private double getSpeed() {
        return EnergyConverter.FUELtoCALORIES(this.heat.getTemperature() / 100.0);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.heat.getTemperature());
        craft.func_71112_a(cont, 1, (int)this.progress);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.heat.setTemperature(value);
        }
        if (id == 1) {
            this.progress = value;
        }
    }

    private void smelt() {
        if (this.canSmelt()) {
            ItemStack a = this.getInv().func_70301_a(0);
            ItemStack b = this.getInv().func_70301_a(1);
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(a);
            if (b == null) {
                this.getInv().func_70299_a(1, itemstack.func_77946_l());
            } else if (b.func_77969_a(itemstack)) {
                b.field_77994_a += itemstack.field_77994_a;
            }
            --a.field_77994_a;
            if (a.field_77994_a <= 0) {
                this.getInv().func_70299_a(0, null);
            }
        }
    }

    private boolean canSmelt() {
        if (this.getInv().func_70301_a(0) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.getInv().func_70301_a(0));
        if (itemstack == null) {
            return false;
        }
        if (this.getInv().func_70301_a(1) == null) {
            return true;
        }
        if (!this.getInv().func_70301_a(1).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.getInv().func_70301_a((int)1).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6 + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.getInv().readFromNBT(nbtTagCompound);
        this.progress = nbtTagCompound.func_74760_g("P");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.getInv().writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74776_a("P", this.progress);
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return a == 0;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 1;
    }

    public IBarProvider getProgresBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return 100.0f;
            }

            @Override
            public float getLevel() {
                return TileBrickFurnace.this.progress;
            }
        };
    }
}

