/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.access;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.util.MgUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipePolymerizer {
    protected FluidStack fluid;
    protected ItemStack input;
    protected ItemStack output;
    protected double minTemperature;

    public RecipePolymerizer(FluidStack fluid, ItemStack input, ItemStack output, double minTemperature) {
        this.fluid = fluid;
        this.input = input;
        this.output = output;
        this.minTemperature = minTemperature;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public double getTemperature() {
        return this.minTemperature;
    }

    public static RecipePolymerizer getRecipe(ItemStack i) {
        for (RecipePolymerizer r : MgRecipeRegister.polymerizer) {
            if (!r.matches(i)) continue;
            return r;
        }
        return null;
    }

    public boolean matches(ItemStack item) {
        return MgUtils.areEqual(item, this.input, true);
    }

    public boolean matches(FluidStack fluid) {
        return MgUtils.areEqual(fluid, this.getFluid());
    }

    public String toString() {
        return "Polymerizer Recipe, Fluid: " + this.fluid.getLocalizedName() + ", Item Input: " + this.input + ", Item Output: " + this.output + ", Temperature: " + this.minTemperature;
    }
}

