/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.ex.missiles;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.explosive.ex.missiles.Missile;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MissileCluster
extends Missile {
    public static final int MAX_CLUSTER = 12;
    protected double spread = 20.0;

    public MissileCluster(String name, int tier) {
        super(name, tier);
        this.hasBlock = false;
        this.missileModelPath = "missiles/tier2/missile_head_cluster.obj";
    }

    @Override
    public void update(EntityMissile missileObj) {
        if (missileObj.field_70181_x < -0.5) {
            if (missileObj.missileCount < 12) {
                if (!missileObj.field_70170_p.field_72995_K) {
                    Pos position = missileObj.toPos();
                    EntityMissile missile = new EntityMissile(missileObj.field_70170_p);
                    missile.func_70107_b(position.x(), position.y(), position.z());
                    missile.launcherPos = position;
                    missile.explosiveID = Explosives.CONDENSED;
                    double radius = this.spread;
                    double theta = 0.0;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    if (missileObj.missileCount > 0) {
                        theta = (double)missileObj.missileCount / 12.0 * Math.PI * 2.0;
                        x = radius * Math.cos(theta);
                        missile.field_70165_t += Math.cos(theta) * 5.0;
                        z = radius * Math.sin(theta);
                        missile.field_70161_v += Math.sin(theta) * 5.0;
                    }
                    missile.missileType = EntityMissile.MissileType.CruiseMissile;
                    missile.protectionTime = 20 + missileObj.targetHeight - 1;
                    missile.launch((Pos)missileObj.targetVector.add((IPos3D)new Pos(x, y, z)));
                    missileObj.field_70170_p.func_72838_d((Entity)missile);
                }
                missileObj.protectionTime = 20;
                ++missileObj.missileCount;
            } else {
                missileObj.func_70106_y();
            }
        }
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastTNT(world, entity, x, y, z, 6.0f).setDestroyItems().explode();
    }

    @Override
    public boolean isCruise() {
        return false;
    }

    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double size, NBTTagCompound tag) {
        return null;
    }
}

