/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.ex.missiles;

import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.explosive.ex.missiles.Missile;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MissileAnti
extends Missile {
    public static final int ABMRange = 30;

    public MissileAnti() {
        super("antiBallistic", 2);
        this.hasBlock = false;
        this.missileModelPath = "missiles/tier2/missile_head_antballistic.obj";
    }

    @Override
    public void update(EntityMissile missileObj) {
        if (missileObj.lockedTarget != null) {
            Pos target = new Pos(missileObj.lockedTarget);
            if (missileObj.lockedTarget.field_70128_L) {
                missileObj.explode();
                return;
            }
            if (missileObj.lockedTarget instanceof EntityMissile) {
                target = ((EntityMissile)missileObj.lockedTarget).getPredictedPosition(4);
            }
            missileObj.field_70159_w = (target.x() - missileObj.field_70165_t) * (double)0.3f;
            missileObj.field_70181_x = (target.y() - missileObj.field_70163_u) * (double)0.3f;
            missileObj.field_70179_y = (target.z() - missileObj.field_70161_v) * (double)0.3f;
            return;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(missileObj.field_70165_t - 30.0), (double)(missileObj.field_70163_u - 30.0), (double)(missileObj.field_70161_v - 30.0), (double)(missileObj.field_70165_t + 30.0), (double)(missileObj.field_70163_u + 30.0), (double)(missileObj.field_70161_v + 30.0));
        Entity nearestEntity = missileObj.field_70170_p.func_72857_a(EntityMissile.class, bounds, (Entity)missileObj);
        if (nearestEntity instanceof EntityMissile) {
            missileObj.lockedTarget = nearestEntity;
            missileObj.didTargetLockBefore = true;
            missileObj.field_70170_p.func_72956_a((Entity)missileObj, "icbmclassic:targetlocked", 5.0f, 0.9f);
        } else {
            missileObj.field_70159_w = missileObj.deltaPathX / (double)missileObj.missileFlightTime;
            missileObj.field_70179_y = missileObj.deltaPathZ / (double)missileObj.missileFlightTime;
            if (missileObj.didTargetLockBefore) {
                missileObj.explode();
            }
        }
    }

    @Override
    public boolean isCruise() {
        return true;
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastTNT(world, entity, x, y, z, 6.0f).setDestroyItems().explode();
    }

    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double size, NBTTagCompound tag) {
        return null;
    }
}

