/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.blast.BlastAntimatter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import resonant.api.explosion.IExplosion;
import resonant.api.explosion.IExplosiveIgnore;

public class BlastRedmatter
extends Blast {
    public static final float NORMAL_RADIUS = 35.0f;
    public static final float ENTITY_DESTROY_RADIUS = 6.0f;
    private static int MAX_BLOCKS_REMOVED_PER_TICK = 10;
    public static int MAX_LIFESPAN = 36000;
    public static boolean DO_DESPAWN = true;
    public static boolean doAudio = true;
    public static boolean doFlyingBlocks = true;
    private AxisAlignedBB bounds;
    private float entityRadius;

    public BlastRedmatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.oldWorld().field_72995_K) {
            this.oldWorld().func_72876_a(this.field_77283_e, this.position.x(), this.position.y(), this.position.z(), 15.0f, true);
        }
    }

    @Override
    protected void doPostExplode() {
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_77284_b - (double)this.field_77280_f), (double)(this.field_77285_c - (double)this.field_77280_f), (double)(this.field_77282_d - (double)this.field_77280_f), (double)(this.field_77284_b + (double)this.field_77280_f), (double)(this.field_77285_c + (double)this.field_77280_f), (double)(this.field_77282_d + (double)this.field_77280_f));
        List list = this.oldWorld().func_72872_a(EntityExplosion.class, bounds);
        for (Object obj : list) {
            EntityExplosion explosion;
            if (!(obj instanceof EntityExplosion) || (explosion = (EntityExplosion)((Object)obj)).getBlast() != this) continue;
            explosion.func_70106_y();
        }
    }

    @Override
    public void doExplode() {
        if (!this.oldWorld().field_72995_K) {
            if (DO_DESPAWN && this.callCount >= MAX_LIFESPAN) {
                this.postExplode();
            }
            this.doDestroyBlocks();
            this.doEntityMovement();
            if (doAudio) {
                if (this.oldWorld().field_73012_v.nextInt(8) == 0) {
                    this.oldWorld().func_72908_a(this.position.x() + (Math.random() - 0.5) * (double)this.getRadius(), this.position.y() + (Math.random() - 0.5) * (double)this.getRadius(), this.position.z() + (Math.random() - 0.5) * (double)this.getRadius(), "icbmclassic:collapse", 6.0f - this.oldWorld().field_73012_v.nextFloat(), 1.0f - this.oldWorld().field_73012_v.nextFloat() * 0.4f);
                }
                this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "icbmclassic:redmatter", 3.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 1.0f);
            }
        }
    }

    protected void doDestroyBlocks() {
        int blocksDestroyed = 0;
        int currentRadius = 1;
        while ((float)currentRadius < this.getRadius()) {
            for (int xr = -currentRadius; xr < currentRadius; ++xr) {
                for (int yr = -currentRadius; yr < currentRadius; ++yr) {
                    for (int zr = -currentRadius; zr < currentRadius; ++zr) {
                        Block block;
                        Location currentPos = (Location)this.position.add((double)xr, (double)yr, (double)zr);
                        double dist = this.position.distance((IPos3D)currentPos);
                        if (dist < (double)currentRadius && dist > (double)(currentRadius - 2) && (block = currentPos.getBlock()) != null) {
                            boolean isFluid = block instanceof BlockLiquid || block instanceof IFluidBlock;
                            int meta = currentPos.getBlockMetadata();
                            if (!block.isAir((IBlockAccess)this.oldWorld(), currentPos.xi(), currentPos.yi(), currentPos.zi()) && (isFluid || block.func_149712_f(this.oldWorld(), currentPos.xi(), currentPos.yi(), currentPos.zi()) >= 0.0f)) {
                                currentPos.setBlock(Blocks.field_150350_a, 0, isFluid ? 2 : 3);
                                if (!isFluid && doFlyingBlocks && (double)this.oldWorld().field_73012_v.nextFloat() > 0.8) {
                                    EntityFlyingBlock entity = new EntityFlyingBlock(this.oldWorld(), (IPos3D)currentPos.add(0.5), block, meta);
                                    entity.yawChange = 50.0f * this.oldWorld().field_73012_v.nextFloat();
                                    entity.pitchChange = 50.0f * this.oldWorld().field_73012_v.nextFloat();
                                    this.oldWorld().func_72838_d((Entity)entity);
                                }
                                ++blocksDestroyed;
                            }
                        }
                        if (blocksDestroyed <= MAX_BLOCKS_REMOVED_PER_TICK && this.isAlive) continue;
                        return;
                    }
                }
            }
            ++currentRadius;
        }
    }

    protected void doEntityMovement() {
        float entityRadius = this.getRadius() * 2.0f;
        Cube cube = new Cube((IPos3D)((Location)this.position.add(0.5)).sub((double)entityRadius), (IPos3D)((Location)this.position.add(0.5)).add((double)entityRadius));
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)cube.min().x(), (double)cube.min().y(), (double)cube.min().z(), (double)cube.max().x(), (double)cube.max().y(), (double)cube.max().z());
        List allEntities = this.oldWorld().func_72872_a(Entity.class, bounds);
        boolean doExplosion = true;
        for (Entity entity : allEntities) {
            doExplosion = !this.affectEntity(entityRadius, entity, doExplosion);
        }
    }

    public boolean affectEntity(float radius, Entity entity, boolean doExplosion) {
        if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).field_71075_bZ.field_75102_a)) {
            return false;
        }
        if (entity == this.controller) {
            return false;
        }
        if (entity instanceof IExplosiveIgnore && ((IExplosiveIgnore)entity).canIgnore((IExplosion)this)) {
            return false;
        }
        double xDifference = entity.field_70165_t - (double)this.position.xi() + 0.5;
        double yDifference = entity.field_70163_u - (double)this.position.yi() + 0.5;
        double zDifference = entity.field_70161_v - (double)this.position.zi() + 0.5;
        double xPercentage = 1.0 - xDifference / (double)radius;
        double yPercentage = 1.0 - yDifference / (double)radius;
        double zPercentage = 1.0 - zDifference / (double)radius;
        double distancePercentage = this.position.distance(entity) / (double)radius;
        Pos entityPosition = new Pos(entity);
        Pos centeredPosition = (Pos)entityPosition.subtract((IPos3D)this.position);
        centeredPosition = (Pos)centeredPosition.transform((ITransform)new EulerAngle(1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random()));
        Location newPosition = (Location)this.position.add((IPos3D)centeredPosition);
        entity.func_70024_g(newPosition.x() - entityPosition.x(), 0.0, newPosition.z() - entityPosition.z());
        entity.func_70024_g(-xDifference * 0.015 * xPercentage, -yDifference * 0.015 * yPercentage, -zDifference * 0.015 * zPercentage);
        boolean explosionCreated = false;
        Pos pos = new Pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (pos.distance((IPos3D)this.position) < (double)(6.0f * (this.getRadius() / 35.0f))) {
            if (entity instanceof EntityExplosion) {
                if (((EntityExplosion)entity).getBlast() instanceof BlastAntimatter) {
                    if (doAudio) {
                        this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "icbmclassic:explosion", 7.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    }
                    if ((double)this.oldWorld().field_73012_v.nextFloat() > 0.85 && !this.oldWorld().field_72995_K) {
                        entity.func_70106_y();
                        return explosionCreated;
                    }
                } else if (((EntityExplosion)entity).getBlast() instanceof BlastRedmatter) {
                    double sizeA = this.getRadius();
                    sizeA = sizeA * sizeA * sizeA;
                    double sizeB = ((EntityExplosion)entity).getBlast().getRadius();
                    sizeB = sizeB * sizeB * sizeB;
                    float radiusNew = (float)Math.cbrt(sizeA + sizeB);
                    this.callCount = (this.callCount + ((EntityExplosion)entity).getBlast().callCount) / 2;
                    this.isAlive = false;
                    this.controller.func_70106_y();
                    new BlastRedmatter(this.oldWorld(), entity, this.position.x(), this.position.y(), this.position.z(), radiusNew).explode();
                }
                ((EntityExplosion)entity).getBlast().isAlive = false;
                entity.func_70106_y();
            } else if (entity instanceof EntityExplosive) {
                ((EntityExplosive)entity).explode();
            } else if (entity instanceof EntityLiving) {
                entity.func_70097_a((DamageSource)new DamageSourceRedmatter(this), 2000.0f);
            } else {
                entity.func_70106_y();
            }
        }
        return explosionCreated;
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public long getEnergy() {
        return -3000L;
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    public static class DamageSourceRedmatter
    extends DamageSource {
        public final BlastRedmatter blastRedmatter;

        public DamageSourceRedmatter(BlastRedmatter blastRedmatter) {
            super("icbm.redmatter");
            this.blastRedmatter = blastRedmatter;
        }
    }
}

