/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.blast.BlastMutation;
import icbm.classic.content.explosive.blast.BlastRot;
import icbm.classic.content.explosive.thread.ThreadLargeExplosion;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlastNuclear
extends Blast {
    private ThreadLargeExplosion thread;
    private float energy;
    private boolean spawnMoreParticles = false;
    private boolean isRadioactive = false;

    public BlastNuclear(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastNuclear(World world, Entity entity, double x, double y, double z, float size, float energy) {
        this(world, entity, x, y, z, size);
        this.energy = energy;
    }

    public BlastNuclear setNuclear() {
        this.spawnMoreParticles = true;
        this.isRadioactive = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        if (!this.oldWorld().field_72995_K) {
            this.thread = new ThreadLargeExplosion((IWorldPosition)this.position, (int)this.getRadius(), this.energy, this.field_77283_e);
            this.thread.start();
        } else if (this.spawnMoreParticles && ICBMClassic.proxy.isGaoQing()) {
            for (int y = 0; y < 26; ++y) {
                int r = 4;
                if (y < 8) {
                    r = Math.max(Math.min((8 - y) * 2, 10), 4);
                } else if (y > 15) {
                    r = Math.max(Math.min((y - 15) * 2, 15), 5);
                }
                for (int x = -r; x < r; ++x) {
                    for (int z = -r; z < r; ++z) {
                        double distance = MathHelper.func_76133_a((double)(x * x + z * z));
                        if (!((double)r > distance) || !((double)(r - 3) < distance)) continue;
                        Location spawnPosition = (Location)this.position.add((IPos3D)new Pos((double)(x * 2), (double)((y - 2) * 2), (double)(z * 2)));
                        float xDiff = (float)(spawnPosition.x() - this.position.x());
                        float zDiff = (float)(spawnPosition.z() - this.position.z());
                        ICBMClassic.proxy.spawnParticle("smoke", this.oldWorld(), (IPos3D)spawnPosition, (double)xDiff * 0.3 * (double)this.oldWorld().field_73012_v.nextFloat(), -this.oldWorld().field_73012_v.nextFloat(), (double)zDiff * 0.3 * (double)this.oldWorld().field_73012_v.nextFloat(), (float)(distance / (double)this.getRadius()) * this.oldWorld().field_73012_v.nextFloat(), 0.0f, 0.0f, 8.0f, 1.2f);
                    }
                }
            }
        }
        this.doDamageEntities(this.getRadius(), this.energy * 1000.0f);
        this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "icbmclassic:explosion", 7.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void doExplode() {
        int r = this.callCount;
        if (this.oldWorld().field_72995_K) {
            if (ICBMClassic.proxy.isGaoQing()) {
                for (int x = -r; x < r; ++x) {
                    for (int z = -r; z < r; ++z) {
                        double distance = MathHelper.func_76133_a((double)(x * x + z * z));
                        if (!(distance < (double)r) || !(distance > (double)(r - 1))) continue;
                        Location targetPosition = (Location)this.position.add((IPos3D)new Pos((double)x, 0.0, (double)z));
                        if (!((double)this.oldWorld().field_73012_v.nextFloat() < Math.max(0.001 * (double)r, 0.05))) continue;
                        ICBMClassic.proxy.spawnParticle("smoke", this.oldWorld(), (IPos3D)targetPosition, 5.0f, 1.0);
                    }
                }
            }
        } else if (this.thread != null) {
            if (this.thread.isComplete) {
                this.controller.endExplosion();
            }
        } else {
            this.controller.endExplosion();
            ICBMClassic.INSTANCE.logger().error("Something went wrong with multi-threading while detonating the nuclear explosive.");
        }
    }

    @Override
    public void doPostExplode() {
        try {
            if (!this.oldWorld().field_72995_K && this.thread.isComplete) {
                for (Pos p : this.thread.results) {
                    Block block = this.oldWorld().func_147439_a(p.xi(), p.yi(), p.zi());
                    if (block == null) continue;
                    block.onBlockExploded(this.oldWorld(), p.xi(), p.yi(), p.zi(), (Explosion)this);
                }
            }
        }
        catch (Exception e) {
            ICBMClassic.INSTANCE.logger().error("Nuclear-type detonation Failed!", (Throwable)e);
        }
        this.doDamageEntities(this.getRadius(), this.energy * 1000.0f);
        if (this.isRadioactive) {
            new BlastRot(this.oldWorld(), this.field_77283_e, this.position.x(), this.position.y(), this.position.z(), this.getRadius(), this.energy).explode();
            new BlastMutation(this.oldWorld(), this.field_77283_e, this.position.x(), this.position.y(), this.position.z(), this.getRadius()).explode();
            if (this.oldWorld().field_73012_v.nextInt(3) == 0) {
                this.oldWorld().field_73004_o = 1.0f;
            }
        }
        this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "icbmclassic:explosion", 10.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public long getEnergy() {
        return (long)(4.184E7f * this.energy);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.spawnMoreParticles = nbt.func_74767_n("spawnMoreParticles");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("spawnMoreParticles", this.spawnMoreParticles);
    }
}

