/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.render.fx.FXElectricBolt;
import com.builtbroken.mc.lib.render.fx.FXElectricBoltSpawner;
import com.builtbroken.mc.lib.render.fx.FXEnderPortalPartical;
import com.builtbroken.mc.lib.render.fx.FXSmoke;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.CommonProxy;
import icbm.classic.ICBMClassic;
import icbm.classic.client.fx.FXAntimatterParticle;
import icbm.classic.client.render.RenderMissile;
import icbm.classic.client.render.entity.RenderEntityBlock;
import icbm.classic.client.render.entity.RenderEntityExplosive;
import icbm.classic.client.render.entity.RenderExplosion;
import icbm.classic.client.render.entity.RenderGrenade;
import icbm.classic.client.render.entity.RenderLightBeam;
import icbm.classic.client.render.entity.RenderSeat;
import icbm.classic.client.render.entity.RenderShrapnel;
import icbm.classic.client.render.item.RenderRocketLauncher;
import icbm.classic.client.render.tile.RenderBombBlock;
import icbm.classic.content.entity.EntityBombCart;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.explosive.ex.missiles.MissilePlayerHandler;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import icbm.classic.content.machines.coordinator.TileMissileCoordinatorClient;
import icbm.classic.content.machines.emptower.TileEMPTowerClient;
import icbm.classic.content.machines.launcher.base.TileLauncherBaseClient;
import icbm.classic.content.machines.launcher.cruise.TileCruiseLauncherClient;
import icbm.classic.content.machines.launcher.frame.TileLauncherFrameClient;
import icbm.classic.content.machines.launcher.screen.TileLauncherScreenClient;
import icbm.classic.content.machines.radarstation.TileRadarStationClient;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean disableReflectionFX = false;

    public void preInit() {
        super.preInit();
        ICBMClassic.blockRadarStation = ICBMClassic.INSTANCE.getManager().newBlock("icbmCRadarStation", (Tile)new TileRadarStationClient());
        ICBMClassic.blockEmpTower = ICBMClassic.INSTANCE.getManager().newBlock("icbmCEmpTower", (Tile)new TileEMPTowerClient());
        ICBMClassic.blockLaunchBase = ICBMClassic.INSTANCE.getManager().newBlock("icbmCLauncherBase", (Tile)new TileLauncherBaseClient());
        ICBMClassic.blockLaunchSupport = ICBMClassic.INSTANCE.getManager().newBlock("icbmCLauncherFrame", (Tile)new TileLauncherFrameClient());
        ICBMClassic.blockLaunchScreen = ICBMClassic.INSTANCE.getManager().newBlock("icbmCLauncherScreen", (Tile)new TileLauncherScreenClient());
        ICBMClassic.blockCruiseLauncher = ICBMClassic.INSTANCE.getManager().newBlock("icbmCCruiseLauncher", (Tile)new TileCruiseLauncherClient());
        ICBMClassic.blockMissileCoordinator = ICBMClassic.INSTANCE.getManager().newBlock("icbmCMissileCoordinator", (Tile)new TileMissileCoordinatorClient());
    }

    public void init() {
        super.init();
        RenderingRegistry.registerEntityRenderingHandler(EntityFlyingBlock.class, (Render)new RenderEntityBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityFragments.class, (Render)new RenderShrapnel());
        MinecraftForgeClient.registerItemRenderer((Item)ICBMClassic.itemRocketLauncher, (IItemRenderer)new RenderRocketLauncher());
        RenderMissile renderMissile = new RenderMissile(0.5f);
        MinecraftForgeClient.registerItemRenderer((Item)ICBMClassic.itemMissile, (IItemRenderer)renderMissile);
        RenderBombBlock bombRender = new RenderBombBlock();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)bombRender);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityExplosive.class, (TileEntitySpecialRenderer)bombRender);
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosive.class, (Render)new RenderEntityExplosive());
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, (Render)renderMissile);
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosion.class, (Render)new RenderExplosion());
        RenderingRegistry.registerEntityRenderingHandler(EntityLightBeam.class, (Render)new RenderLightBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderGrenade());
        RenderingRegistry.registerEntityRenderingHandler(EntityBombCart.class, (Render)new RenderMinecart());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayerSeat.class, (Render)new RenderSeat());
    }

    @Override
    public boolean isGaoQing() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @Override
    public int getParticleSetting() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    @Override
    public void spawnParticle(String name, World world, IPos3D position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
        Object fx = null;
        if (name.equals("smoke")) {
            fx = new FXSmoke(world, new Pos(position), red, green, blue, scale, distance);
        } else if (name.equals("missile_smoke")) {
            fx = new FXSmoke(world, new Pos(position), red, green, blue, scale, distance).setAge(100);
        } else if (name.equals("portal")) {
            fx = new FXEnderPortalPartical(world, new Pos(position), red, green, blue, scale, distance);
        } else if (name.equals("antimatter")) {
            fx = new FXAntimatterParticle(world, new Pos(position), red, green, blue, scale, distance);
        } else if (name.equals("digging")) {
            fx = new EntityDiggingFX(world, position.x(), position.y(), position.z(), motionX, motionY, motionZ, Block.func_149729_e((int)((int)red)), 0, (int)green);
            fx.func_70541_f(blue);
        } else if (name.equals("shockwave")) {
            // empty if block
        }
        if (fx != null) {
            fx.field_70159_w = motionX;
            fx.field_70181_x = motionY;
            fx.field_70179_y = motionZ;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBolt(world, (IPos3D)startVec, (IPos3D)targetVec, 0L));
    }

    @Override
    public void spawnShock(World world, IPos3D startVec, IPos3D targetVec, int duration) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBoltSpawner(world, startVec, targetVec, 0L, duration));
    }

    @Override
    public IUpdatePlayerListBox getDaoDanShengYin(EntityMissile eDaoDan) {
        return new MissilePlayerHandler(null, eDaoDan, (EntityPlayerSP)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public List<Entity> getEntityFXs() {
        if (!this.disableReflectionFX) {
            try {
                EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
                List[] fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)renderer, (int)2);
                return fxLayers[0];
            }
            catch (Exception e) {
                ICBMClassic.INSTANCE.logger().error("Failed to use refection on entity effects.", (Throwable)e);
                this.disableReflectionFX = true;
            }
        }
        return null;
    }
}

