/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.SaloonDoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SaloonDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity te, boolean topBlock, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION || te.isMoving()) {
            return null;
        }
        float f = 0.0625f;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.25, (double)(0.5f - f / 2.0f), (double)1.0, (double)1.0, (double)(0.5f + f / 2.0f));
        if (topBlock) {
            aabb.func_72317_d(0.0, -0.25, 0.0);
        }
        if (type == BoundingBoxType.SELECTION) {
            if (topBlock) {
                aabb.field_72338_b -= 0.75;
            } else {
                aabb.field_72337_e += 0.75;
            }
        }
        return aabb;
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        float f = 0.0625f;
        float angle = 90.0f;
        float hingeX = 0.5f - f / 2.0f;
        if (tileEntity.isReversed()) {
            angle = -angle;
        }
        if (((SaloonDoorTileEntity)tileEntity).isBackward()) {
            angle = -angle;
        }
        int t = tileEntity.getDescriptor().getOpeningTime() / 4;
        Rotation r1 = new Rotation(angle);
        r1.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r1.movement(1);
        r1.forTicks(t);
        Rotation r2 = new Rotation(-angle * 1.5f);
        r2.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r2.movement(1);
        r2.forTicks(t);
        Rotation r3 = new Rotation(angle * 0.75f);
        r3.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r3.movement(1);
        r3.forTicks(t);
        Rotation r4 = new Rotation(-angle * 0.25f);
        r4.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r4.movement(1);
        r4.forTicks(t);
        ChainedTransformation ct = new ChainedTransformation(new Transformation[]{r1, r2, r3, r4});
        return ct;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

