/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.client.gui.buttons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import main.ironbackpacks.client.gui.buttons.ButtonTypes;
import main.ironbackpacks.client.gui.buttons.ITooltipButton;
import main.ironbackpacks.handlers.ConfigHandler;
import main.ironbackpacks.util.IronBackpacksConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TooltipButton
extends GuiButton
implements ITooltipButton {
    public static final ResourceLocation widgetTextures = IronBackpacksConstants.Resources.WIDGETS;
    private int buttonID;
    private int iconOffsetX;
    private int iconOffsetY;
    private ArrayList<String> tooltips;
    private int hoverTime;

    public TooltipButton(ButtonTypes buttonType, int xPos, int yPos) {
        super(buttonType.id, xPos, yPos, buttonType.sizeX, buttonType.sizeY, "");
        this.buttonID = buttonType.id;
        this.hoverTime = buttonType.delay ? ConfigHandler.tooltipDelay : 0;
        this.tooltips = new ArrayList();
        for (String string : buttonType.tooltip) {
            this.tooltips.add(string);
        }
        this.iconOffsetX = buttonType.iconOffsetX;
        this.iconOffsetY = buttonType.iconOffsetY;
    }

    public TooltipButton(int id, ButtonTypes buttonType, int xPos, int yPos, String ... tooltipLines) {
        super(id, xPos, yPos, buttonType.sizeX, buttonType.sizeY, "");
        this.buttonID = id;
        this.hoverTime = buttonType.delay ? ConfigHandler.tooltipDelay : 0;
        this.tooltips = new ArrayList();
        for (String string : tooltipLines.length == 0 ? buttonType.tooltip : tooltipLines) {
            this.tooltips.add(string);
        }
        this.iconOffsetX = buttonType.iconOffsetX;
        this.iconOffsetY = buttonType.iconOffsetY;
    }

    public void func_146112_a(Minecraft minecraft, int mPosX, int mPosY) {
        if (this.field_146125_m) {
            minecraft.func_110434_K().func_110577_a(widgetTextures);
            boolean hover = this.mouseInButton(mPosX, mPosY);
            int h = this.func_146114_a(hover);
            int fromLeft = this.iconOffsetX + (h - 1) * (this.field_146120_f + 1);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, fromLeft, this.iconOffsetY, this.field_146120_f, this.field_146121_g);
        }
    }

    @Override
    public boolean mouseInButton(int mPosX, int mPosY) {
        return mPosX >= this.field_146128_h && mPosY >= this.field_146129_i && mPosX < this.field_146128_h + this.field_146120_f && mPosY < this.field_146129_i + this.field_146121_g;
    }

    @Override
    public ArrayList<String> getTooltip() {
        return this.tooltips;
    }

    @Override
    public int getHoverTime() {
        return this.hoverTime;
    }

    public static int incrementType(GuiButton button) {
        int buttonID = ((TooltipButton)button).buttonID;
        if (buttonID < ButtonTypes.MOD_SPECIFIC.id) {
            return ++buttonID;
        }
        return ButtonTypes.EXACT.id;
    }
}

