/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.item.ItemPlayerRelocator;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.multiblock.TileMultiBlockBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TilePlayerRelocatorBase
extends TileMultiBlockBase {
    public boolean isLocked = false;
    private String linkedUUID;

    @Override
    public String getMultiBlockIdentifier() {
        return "playerRelocator";
    }

    @Override
    public boolean shouldAutoCheckFormation() {
        return false;
    }

    public boolean isIntraLinker() {
        return this.type == 1;
    }

    public boolean isLinked() {
        return this.linkedUUID != null;
    }

    public String getLinkedUUID() {
        return this.linkedUUID;
    }

    public void setLinkedUUID(String linkedUUID) {
        this.linkedUUID = linkedUUID;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.linkedUUID = compound.func_74779_i("UUID");
        this.isLocked = compound.func_74767_n("isLocked");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.linkedUUID != null && !this.linkedUUID.isEmpty()) {
            compound.func_74778_a("UUID", this.linkedUUID);
        }
        compound.func_74757_a("isLocked", this.isLocked);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 3.0, 1.0);
    }

    public boolean onActivated(World world, EntityPlayer player, int side) {
        if (!this.isFormed(true)) {
            return false;
        }
        if (world.field_72995_K) {
            world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (player.func_70093_af()) {
            if (this.canPlayerToggleLock(player)) {
                this.isLocked = !this.isLocked;
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.TOGGLE_LOCK)));
            }
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.LINK_RELOCATOR_BASE)));
        }
        this.func_70296_d();
        world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean canPlayerToggleLock(EntityPlayer player) {
        if (!this.isLinked()) {
            return false;
        }
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemPlayerRelocator) || !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("UUID") || !this.getLinkedUUID().equals(itemStack.func_77978_p().func_74779_i("UUID"))) continue;
            return true;
        }
        return false;
    }
}

