/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.item.IItemRelocatorModule;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.client.gui.GuiModuleMultiModule;
import com.dynious.refinedrelocation.container.ContainerMultiModule;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleRegistry;
import com.dynious.refinedrelocation.helper.StringHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class RelocatorMultiModule
extends RelocatorModuleBase {
    private static IIcon icon;
    private List<IRelocatorModule> modules = new ArrayList<IRelocatorModule>();
    private int currentModule = -1;

    public RelocatorMultiModule() {
        super(new ItemStack((Item)ModItems.relocatorModule, 1, 10));
    }

    public IRelocatorModule getCurrentModule() {
        return this.currentModule == -1 ? this : this.modules.get(this.currentModule);
    }

    public void setCurrentModule(int newModule) {
        this.currentModule = newModule;
    }

    public List<List<String>> getModuleInformation(NBTTagCompound compound) {
        ArrayList<List<String>> moduleInformation = new ArrayList<List<String>>();
        NBTTagList list = compound.func_150295_c("multiModules", 10);
        for (int i = 0; i < list.func_74745_c() && i <= 3; ++i) {
            List<String> wailaInfo;
            NBTTagCompound moduleCompound = list.func_150305_b(i);
            IRelocatorModule module = RelocatorModuleRegistry.getModule(moduleCompound.func_74779_i("clazzIdentifier"));
            if (module == null || (wailaInfo = module.getWailaInformation(moduleCompound)).isEmpty()) continue;
            for (int j = 0; j < wailaInfo.size(); ++j) {
                wailaInfo.set(j, StringUtils.repeat((String)" ", (int)3) + wailaInfo.get(j));
            }
            wailaInfo.add(0, module.getDisplayName());
            moduleInformation.add(wailaInfo);
        }
        if (list.func_74745_c() >= 4) {
            ArrayList<String> ellipse = new ArrayList<String>();
            ellipse.add(StringHelper.getLocalizedString(Strings.ELLIPSE));
            moduleInformation.add(ellipse);
        }
        return moduleInformation;
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule10.name");
    }

    public boolean addModule(IRelocatorModule module) {
        for (IRelocatorModule module1 : this.modules) {
            if (module1.getClass() != module.getClass() && !(module instanceof RelocatorMultiModule)) continue;
            return false;
        }
        this.modules.add(module);
        return true;
    }

    public IRelocatorModule removeModule(int index) {
        return this.modules.remove(index);
    }

    @Override
    public void init(IItemRelocator relocator, int side) {
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            module.init(relocator, side);
        }
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        IRelocatorModule module;
        if (stack != null && stack.func_77973_b() instanceof IItemRelocatorModule && (module = ((IItemRelocatorModule)stack.func_77973_b()).getRelocatorModule(stack)) != null && this.addModule(module)) {
            module.init(relocator, side);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        APIUtils.openRelocatorModuleGUI(relocator, player, side);
        return true;
    }

    @Override
    public void onUpdate(IItemRelocator relocator, int side) {
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            module.onUpdate(relocator, side);
        }
    }

    @Override
    public ItemStack outputToSide(IItemRelocator relocator, int side, TileEntity inventory, ItemStack stack, boolean simulate) {
        ItemStack returned = stack;
        for (IRelocatorModule module : this.modules) {
            if (module != null) {
                returned = module.outputToSide(relocator, side, inventory, stack, simulate);
            }
            if (returned != null) continue;
            return null;
        }
        return returned;
    }

    @Override
    public void onRedstonePowerChange(boolean isPowered) {
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            module.onRedstonePowerChange(isPowered);
        }
    }

    @Override
    public int strongRedstonePower(int side) {
        int power = 0;
        for (IRelocatorModule module : this.modules) {
            int p;
            if (module == null || (p = module.strongRedstonePower(side)) <= power) continue;
            power = p;
        }
        return power;
    }

    @Override
    public boolean connectsToRedstone() {
        for (IRelocatorModule module : this.modules) {
            if (module == null || !module.connectsToRedstone()) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IItemRelocator relocator, int side, EntityPlayer player) {
        if (this.currentModule == -1) {
            return new GuiModuleMultiModule(this, relocator, side);
        }
        return this.getCurrentModule().getGUI(relocator, side, player);
    }

    @Override
    public Container getContainer(IItemRelocator relocator, int side, EntityPlayer player) {
        if (this.currentModule == -1) {
            return new ContainerMultiModule(this, relocator, side);
        }
        return this.getCurrentModule().getContainer(relocator, side, player);
    }

    @Override
    public boolean passesFilter(IItemRelocator relocator, int side, ItemStack stack, boolean input, boolean simulate) {
        for (IRelocatorModule module : this.modules) {
            if (module == null || module.passesFilter(relocator, side, stack, input, simulate)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("multiModules", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound1 = list.func_150305_b(i);
            IRelocatorModule module = RelocatorModuleRegistry.getModule(compound1.func_74779_i("clazzIdentifier"));
            if (module == null) continue;
            this.modules.add(module);
            module.init(relocator, side);
            module.readFromNBT(relocator, side, compound1);
        }
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            NBTTagCompound compound1 = new NBTTagCompound();
            compound1.func_74778_a("clazzIdentifier", RelocatorModuleRegistry.getIdentifier(module.getClass()));
            module.writeToNBT(relocator, side, compound1);
            list.func_74742_a((NBTBase)compound1);
        }
        compound.func_74782_a("multiModules", (NBTBase)list);
    }

    @Override
    public void readClientData(IItemRelocator relocator, int side, NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("multiModules", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound1 = list.func_150305_b(i);
            IRelocatorModule module = RelocatorModuleRegistry.getModule(compound1.func_74779_i("clazzIdentifier"));
            if (module == null) continue;
            this.modules.add(module);
            module.init(relocator, side);
            module.readClientData(relocator, side, compound1);
        }
    }

    @Override
    public void writeClientData(IItemRelocator relocator, int side, NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            NBTTagCompound compound1 = new NBTTagCompound();
            compound1.func_74778_a("clazzIdentifier", RelocatorModuleRegistry.getIdentifier(module.getClass()));
            module.writeClientData(relocator, side, compound1);
            list.func_74742_a((NBTBase)compound1);
        }
        compound.func_74782_a("multiModules", (NBTBase)list);
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            drops.addAll(module.getDrops(relocator, side));
        }
        drops.add(new ItemStack((Item)ModItems.relocatorModule, 1, 10));
        return drops;
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleMulti");
    }

    public List<IRelocatorModule> getModules() {
        return this.modules;
    }

    public int getModuleCount() {
        return this.modules.size();
    }
}

