/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.client.gui.GuiModuleStock;
import com.dynious.refinedrelocation.compat.waila.RelocatorHUDHandler;
import com.dynious.refinedrelocation.container.ContainerModuleStock;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleStock
extends RelocatorModuleBase
implements IInventory {
    private static IIcon icon;
    private ItemStack[] itemStacksToStock = new ItemStack[9];

    public RelocatorModuleStock() {
        super(new ItemStack((Item)ModItems.relocatorModule, 1, 6));
    }

    @Override
    public ItemStack outputToSide(IItemRelocator relocator, int side, TileEntity tile, ItemStack stack, boolean simulate) {
        if (!this.hasToStock(stack)) {
            return stack;
        }
        if (tile != null && tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            int itemsNeeded = this.getAmountOfItemsNeededToStock(stack) - this.getAmountOfItemsInInventory(inventory, ForgeDirection.OPPOSITES[side], stack);
            if (itemsNeeded > 0) {
                if (stack.field_77994_a > itemsNeeded) {
                    ItemStack returnedStack = IOHelper.insert(inventory, stack.func_77979_a(itemsNeeded), ForgeDirection.OPPOSITES[side], simulate);
                    if (returnedStack != null) {
                        stack.field_77994_a += returnedStack.field_77994_a;
                    }
                    return stack;
                }
                return IOHelper.insert(inventory, stack, ForgeDirection.OPPOSITES[side], simulate);
            }
            return stack;
        }
        return super.outputToSide(relocator, side, tile, stack, simulate);
    }

    public boolean hasToStock(ItemStack stack) {
        for (ItemStack itemToStock : this.itemStacksToStock) {
            if (!ItemStackHelper.areItemStacksEqual(stack, itemToStock)) continue;
            return true;
        }
        return false;
    }

    public int getAmountOfItemsInInventory(IInventory inventory, int side, ItemStack stack) {
        int amount = 0;
        if (inventory instanceof ISidedInventory) {
            int[] accessibleSlots;
            for (int slot : accessibleSlots = ((ISidedInventory)inventory).func_94128_d(side)) {
                amount += this.getAmountOfItemsInSlot(inventory, slot, stack);
            }
        } else {
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                amount += this.getAmountOfItemsInSlot(inventory, slot, stack);
            }
        }
        return amount;
    }

    public int getAmountOfItemsInSlot(IInventory inventory, int slot, ItemStack stack) {
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        if (ItemStackHelper.areItemStacksEqual(stackInSlot, stack)) {
            return stackInSlot.field_77994_a;
        }
        return 0;
    }

    public int getAmountOfItemsNeededToStock(ItemStack stack) {
        int amount = 0;
        for (ItemStack itemToStock : this.itemStacksToStock) {
            if (!ItemStackHelper.areItemStacksEqual(stack, itemToStock)) continue;
            amount += itemToStock.field_77994_a;
        }
        return amount;
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorModuleGUI(relocator, player, side);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IItemRelocator relocator, int side, EntityPlayer player) {
        return new GuiModuleStock(player, this);
    }

    @Override
    public Container getContainer(IItemRelocator relocator, int side, EntityPlayer player) {
        return new ContainerModuleStock(player, this);
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        return Arrays.asList(new ItemStack((Item)ModItems.relocatorModule, 1, 6));
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleStock");
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule6.name");
    }

    public int func_70302_i_() {
        return this.itemStacksToStock.length;
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.itemStacksToStock.length) continue;
            this.itemStacksToStock[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemStacksToStock.length; ++i) {
            if (this.itemStacksToStock[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemStacksToStock[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public ItemStack func_70301_a(int par1) {
        return this.itemStacksToStock[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemStacksToStock[par1] != null) {
            if (this.itemStacksToStock[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemStacksToStock[par1];
                this.itemStacksToStock[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.itemStacksToStock[par1].func_77979_a(par2);
            if (this.itemStacksToStock[par1].field_77994_a == 0) {
                this.itemStacksToStock[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemStacksToStock[par1] != null) {
            ItemStack itemstack = this.itemStacksToStock[par1];
            this.itemStacksToStock[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.itemStacksToStock[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "relocatorModule.stock";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    @Override
    public List<String> getWailaInformation(NBTTagCompound nbtData) {
        List<String> information = super.getWailaInformation(nbtData);
        ArrayList<ItemStack> stockedItemStacks = new ArrayList<ItemStack>();
        NBTTagList nbttaglist = nbtData.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            RelocatorHUDHandler.addStack(stockedItemStacks, itemStack);
        }
        for (ItemStack itemStack : stockedItemStacks) {
            information.add(itemStack.func_82833_r() + " x " + itemStack.field_77994_a);
        }
        return information;
    }
}

