/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleSpread
extends RelocatorModuleBase {
    private static IIcon icon;

    public RelocatorModuleSpread() {
        super(new ItemStack((Item)ModItems.relocatorModule, 1, 8));
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule8.name");
    }

    @Override
    public ItemStack outputToSide(IItemRelocator relocator, int side, TileEntity inventory, ItemStack stack, boolean simulate) {
        if (simulate || !(inventory instanceof IInventory)) {
            return super.outputToSide(relocator, side, inventory, stack, simulate);
        }
        IInventory inv = (IInventory)inventory;
        int oppSide = ForgeDirection.OPPOSITES[side];
        ArrayList<SlotAndFreeSpace> sortedSlotList = new ArrayList<SlotAndFreeSpace>();
        if (inv instanceof ISidedInventory) {
            int[] accessible = ((ISidedInventory)inv).func_94128_d(oppSide);
            for (int slot = accessible.length - 1; slot >= 0; --slot) {
                this.checkAndAddSlot(inv, accessible[slot], oppSide, stack, sortedSlotList);
            }
        } else {
            for (int slot = inv.func_70302_i_() - 1; slot >= 0; --slot) {
                this.checkAndAddSlot(inv, slot, oppSide, stack, sortedSlotList);
            }
        }
        if (!sortedSlotList.isEmpty()) {
            while (((SlotAndFreeSpace)sortedSlotList.get((int)0)).freeSpace != 0) {
                for (int i = 0; i < sortedSlotList.size(); ++i) {
                    SlotAndFreeSpace slotAndFreeSpace = (SlotAndFreeSpace)sortedSlotList.get(i);
                    for (int y = i; y >= 0; --y) {
                        SlotAndFreeSpace slotAndFreeSpace1 = (SlotAndFreeSpace)sortedSlotList.get(y);
                        if (slotAndFreeSpace == slotAndFreeSpace1) {
                            if (slotAndFreeSpace.freeSpace == 0) continue;
                            this.addAmount(inv, slotAndFreeSpace1, 1, stack);
                            if (stack.field_77994_a > 0) continue;
                            return null;
                        }
                        if (slotAndFreeSpace1.freeSpace <= slotAndFreeSpace.freeSpace) continue;
                        int added = Math.min(slotAndFreeSpace1.freeSpace - slotAndFreeSpace.freeSpace, stack.field_77994_a);
                        this.addAmount(inv, slotAndFreeSpace1, added, stack);
                        if (stack.field_77994_a > 0) continue;
                        return null;
                    }
                }
            }
        }
        return stack;
    }

    public void addAmount(IInventory inv, SlotAndFreeSpace slotAndFreeSpace, int added, ItemStack stack) {
        ItemStack stack1 = inv.func_70301_a(slotAndFreeSpace.SLOT);
        if (stack1 != null) {
            stack1.field_77994_a += added;
        } else {
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = added;
            inv.func_70299_a(slotAndFreeSpace.SLOT, newStack);
        }
        slotAndFreeSpace.freeSpace -= added;
        stack.field_77994_a -= added;
    }

    public void checkAndAddSlot(IInventory inventory, int slot, int side, ItemStack itemStack, List<SlotAndFreeSpace> list) {
        if (IOHelper.canInsertItemToInventory(inventory, itemStack, slot, side)) {
            ItemStack contents = inventory.func_70301_a(slot);
            if (contents == null) {
                list.add(0, new SlotAndFreeSpace(slot, inventory.func_70297_j_()));
            } else if (ItemStackHelper.areItemStacksEqual(contents, itemStack)) {
                int freeSpace = inventory.func_70297_j_() - contents.field_77994_a;
                for (int i = 0; i < list.size(); ++i) {
                    if (freeSpace < list.get((int)i).freeSpace) continue;
                    list.add(i, new SlotAndFreeSpace(slot, freeSpace));
                    return;
                }
                list.add(new SlotAndFreeSpace(slot, freeSpace));
            }
        }
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        return Arrays.asList(new ItemStack((Item)ModItems.relocatorModule, 1, 8));
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleSpread");
    }

    public static class SlotAndFreeSpace {
        public final int SLOT;
        public int freeSpace;

        public SlotAndFreeSpace(int slot, int freeSpace) {
            this.SLOT = slot;
            this.freeSpace = freeSpace;
        }
    }
}

