/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.client.gui.GuiModuleSneaky;
import com.dynious.refinedrelocation.container.ContainerModuleSneaky;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.StringHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleSneaky
extends RelocatorModuleBase {
    private static IIcon icon;
    private int side;
    private int outputSide = -1;
    private TileRelocator tileRelocator;

    public RelocatorModuleSneaky() {
        super(new ItemStack((Item)ModItems.relocatorModule, 1, 5));
    }

    @Override
    public void init(IItemRelocator relocator, int side) {
        this.tileRelocator = (TileRelocator)relocator.getTileEntity();
        this.outputSide = ForgeDirection.OPPOSITES[side];
        this.side = side;
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorModuleGUI(relocator, player, side);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IItemRelocator relocator, int side, EntityPlayer player) {
        return new GuiModuleSneaky(this);
    }

    @Override
    public Container getContainer(IItemRelocator relocator, int side, EntityPlayer player) {
        return new ContainerModuleSneaky(this);
    }

    @Override
    public ItemStack outputToSide(IItemRelocator relocator, int side, TileEntity inventory, ItemStack stack, boolean simulate) {
        return IOHelper.insert(inventory, stack, ForgeDirection.getOrientation((int)this.outputSide), simulate);
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.outputSide = compound.func_74771_c("outputSide");
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        compound.func_74774_a("outputSide", (byte)this.outputSide);
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 5));
        return list;
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule5.name");
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleSneaky");
    }

    public int getOutputSide() {
        return this.outputSide;
    }

    public void setOutputSide(int outputSide) {
        this.outputSide = outputSide;
    }

    public TileRelocator getRelocator() {
        return this.tileRelocator;
    }

    public ForgeDirection getSide() {
        return ForgeDirection.getOrientation((int)this.side);
    }

    @Override
    public List<String> getWailaInformation(NBTTagCompound nbtData) {
        List<String> information = super.getWailaInformation(nbtData);
        information.add(StringHelper.getLocalizedString(Strings.OUTPUT_SIDE) + " " + StringHelper.getLocalizedDirection(nbtData.func_74771_c("outputSide")));
        return information;
    }
}

