/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.filter;

import com.dynious.refinedrelocation.api.filter.IChecklistFilter;
import com.dynious.refinedrelocation.api.gui.IGuiWidgetWrapped;
import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiFilterList;
import com.dynious.refinedrelocation.grid.filter.MultiFilterChildBase;
import com.dynious.refinedrelocation.handler.LoginSyncHandler;
import com.dynious.refinedrelocation.lib.Strings;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;

public class ModFilter
extends MultiFilterChildBase
implements IChecklistFilter {
    public static final String TYPE_NAME = "mod";
    private static TextureRegion iconTexture;
    private static String[] serverSideModIDs;
    private static String[] modNames;
    private boolean[] modStates;

    public static void syncMods(String[] modIDs) {
        serverSideModIDs = modIDs;
        modNames = new String[modIDs.length];
        for (int i = 0; i < modIDs.length; ++i) {
            ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modIDs[i]);
            ModFilter.modNames[i] = modContainer != null ? modContainer.getName() : modIDs[i];
        }
    }

    public ModFilter() {
        if (serverSideModIDs == null) {
            serverSideModIDs = LoginSyncHandler.getModIDs();
        }
        this.modStates = new boolean[serverSideModIDs.length];
    }

    @Override
    public boolean isInFilter(ItemStack itemStack) {
        GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
        if (identifier != null) {
            for (int i = 0; i < this.modStates.length; ++i) {
                if (!this.modStates[i] || !serverSideModIDs[i].equals(identifier.modId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.modStates.length; ++i) {
            if (!this.modStates[i]) continue;
            tagList.func_74742_a((NBTBase)new NBTTagString(serverSideModIDs[i]));
        }
        compound.func_74782_a("modStates", (NBTBase)tagList);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList tagList = compound.func_150295_c("modStates", 8);
        block0: for (int i = 0; i < tagList.func_74745_c(); ++i) {
            String tabLabel = tagList.func_150307_f(i);
            for (int j = 0; j < serverSideModIDs.length; ++j) {
                if (!serverSideModIDs[j].equals(tabLabel)) continue;
                this.modStates[j] = true;
                continue block0;
            }
        }
    }

    @Override
    public void sendUpdate(EntityPlayerMP playerMP) {
        this.getParentFilter().sendBooleanArrayToPlayer(this, playerMP, 0, this.modStates);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiWidgetWrapped getGuiWidget(int x, int y, int width, int height) {
        return new GuiFilterList(x, y, width, height, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIconSheet() {
        if (iconTexture == null) {
            iconTexture = SharedAtlas.findRegion("icon_filter_mod");
        }
        return ModFilter.iconTexture.texture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconX() {
        return iconTexture.getRegionX();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconY() {
        return iconTexture.getRegionY();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconWidth() {
        return iconTexture.getRegionWidth();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconHeight() {
        return iconTexture.getRegionHeight();
    }

    @Override
    public void setFilterBooleanArray(int optionId, boolean[] values) {
        this.modStates = values;
    }

    @Override
    public void setFilterBoolean(int optionId, boolean value) {
        this.modStates[optionId] = value;
    }

    @Override
    public void setFilterString(int optionId, String value) {
    }

    @Override
    public String getName(int index) {
        return modNames[index];
    }

    @Override
    public void setValue(int optionIndex, boolean value) {
        this.modStates[optionIndex] = value;
        this.markDirty(true);
    }

    @Override
    public boolean getValue(int optionIndex) {
        return this.modStates[optionIndex];
    }

    @Override
    public int getOptionCount() {
        return this.modStates.length;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getNameLangKey() {
        return Strings.MOD_FILTER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDescriptionLangKey() {
        return Strings.MOD_FILTER_DESCRIPTION;
    }
}

