/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.compat.waila;

import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.helper.StringHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileWirelessBlockExtender;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockExtenderHUDHandler
implements IWailaDataProvider {
    private static String getLocalizedRedstoneState(TileBlockExtender blockExtender) {
        if (blockExtender.isRedstoneTransmissionEnabled()) {
            return blockExtender.isRedstoneTransmissionActive() ? StatCollector.func_74838_a((String)Strings.ACTIVE) : StatCollector.func_74838_a((String)Strings.INACTIVE);
        }
        return StatCollector.func_74838_a((String)Strings.DISABLED);
    }

    public ItemStack getWailaStack(IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> strings, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return strings;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> strings, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        if (iWailaDataAccessor.getTileEntity() instanceof TileBlockExtender) {
            TileBlockExtender blockExtender = (TileBlockExtender)iWailaDataAccessor.getTileEntity();
            if (blockExtender instanceof TileWirelessBlockExtender) {
                TileWirelessBlockExtender wirelessBlockExtender = (TileWirelessBlockExtender)blockExtender;
                if (wirelessBlockExtender.isLinked()) {
                    Block linkedBlock = wirelessBlockExtender.func_145831_w().func_147439_a(wirelessBlockExtender.xConnected, wirelessBlockExtender.yConnected, wirelessBlockExtender.zConnected);
                    int linkedMetadata = wirelessBlockExtender.func_145831_w().func_72805_g(wirelessBlockExtender.xConnected, wirelessBlockExtender.yConnected, wirelessBlockExtender.zConnected);
                    strings.add(StatCollector.func_74838_a((String)Strings.LINKED_TO) + SpecialChars.TAB + BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata) + " " + StringHelper.formatCoordinates(wirelessBlockExtender.xConnected, wirelessBlockExtender.yConnected, wirelessBlockExtender.zConnected));
                } else {
                    strings.add(StatCollector.func_74838_a((String)Strings.UNLINKED));
                }
            } else {
                if (blockExtender.hasConnection()) {
                    strings.add(StatCollector.func_74838_a((String)Strings.CONNECTED_TO) + SpecialChars.TAB + BlockHelper.getTileEntityDisplayName(blockExtender.getConnectedTile()));
                } else {
                    strings.add(StatCollector.func_74838_a((String)Strings.NOT_CONNECTED));
                }
                if (blockExtender.getConnectedDirection() != ForgeDirection.UNKNOWN) {
                    strings.add(StatCollector.func_74838_a((String)Strings.FACING) + SpecialChars.TAB + StringHelper.getLocalizedDirection(blockExtender.getConnectedDirection()));
                }
                strings.add(StatCollector.func_74838_a((String)Strings.REDSTONE) + SpecialChars.TAB + BlockExtenderHUDHandler.getLocalizedRedstoneState(blockExtender));
            }
        }
        return strings;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> strings, IWailaDataAccessor iWailaDataAccessor, IWailaConfigHandler iWailaConfigHandler) {
        return strings;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP entityPlayerMP, TileEntity tileEntity, NBTTagCompound nbtTagCompound, World world, int i, int i1, int i2) {
        if (tileEntity != null) {
            tileEntity.func_145841_b(nbtTagCompound);
        }
        return nbtTagCompound;
    }
}

