/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.GuiRefinedRelocationContainer;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiLabel;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;

public class GuiButtonToggle
extends GuiButton {
    private final TextureRegion[] textureActive = new TextureRegion[2];
    private final TextureRegion[] textureInactive = new TextureRegion[2];
    protected boolean state;
    protected GuiLabel labelTrue;
    protected GuiLabel labelFalse;

    public GuiButtonToggle(IGuiParent parent, int x, int y, int w, int h, String textureNameInactive, String textureNameActive, String labelTrueText, String labelFalseText) {
        super(parent, x, y, w, h, null, null);
        this.labelFalse = new GuiLabel(this, x + w / 2, y + h / 2, labelFalseText, 0xFFFFFF, true);
        this.labelTrue = new GuiLabel(this, x + w / 2, y + h / 2, labelTrueText, 0xFFFFFF, true);
        this.textureInactive[0] = SharedAtlas.findRegion(textureNameInactive);
        this.textureInactive[1] = SharedAtlas.findRegion(textureNameInactive + "_hover");
        this.textureActive[0] = SharedAtlas.findRegion(textureNameActive);
        this.textureActive[1] = SharedAtlas.findRegion(textureNameActive + "_hover");
        this.setButtonTextures(this.textureInactive);
        this.setState(false);
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
        if (state) {
            this.labelTrue.setVisible(true);
            this.labelFalse.setVisible(false);
            this.setButtonTextures(this.textureActive);
        } else {
            this.labelFalse.setVisible(true);
            this.labelTrue.setVisible(false);
            this.setButtonTextures(this.textureInactive);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isInsideBounds(mouseX, mouseY) && (type == 0 || type == 1)) {
            if (!this.isAdventureModeRestriction() || !GuiRefinedRelocationContainer.isRestrictedAccessWithError()) {
                this.setState(!this.getState());
                this.onStateChangedByUser(this.getState());
            }
            return;
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    protected void onStateChangedByUser(boolean newState) {
    }
}

