/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonCounter;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleExtraction;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.lib.Strings;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonTicksBetweenExtractions
extends GuiButtonCounter {
    private static final DecimalFormat decimalFormat = new DecimalFormat("##.##");
    private RelocatorModuleExtraction module;

    public GuiButtonTicksBetweenExtractions(IGuiParent parent, int x, int y, RelocatorModuleExtraction module) {
        super(parent, x, y, 24, 20, Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION, Integer.MAX_VALUE, 1, 10);
        this.module = module;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.module == null) {
            return;
        }
        this.module.setTicksBetweenExtraction((int)newValue);
        GuiHelper.sendIntMessage(0, (int)newValue);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            float seconds = (float)this.module.getTicksBetweenExtraction() / 20.0f;
            tooltip.add(StatCollector.func_74838_a((String)Strings.TICKS_BETWEEN_EXT));
            tooltip.add(decimalFormat.format(seconds) + " " + StatCollector.func_74838_a((String)Strings.SECONDS_BETWEEN_EXT));
        }
    }

    @Override
    public void update() {
        if (this.module != null) {
            this.setValue(this.module.getTicksBetweenExtraction());
        }
        super.update();
    }
}

