/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.GuiRefinedRelocationContainer;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileAdvancedBuffer;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiInsertDirection
extends GuiWidgetBase {
    public static final int defaultSizeW = 16;
    public static final int defaultSizeH = 16;
    private final TextureRegion[][] textureRegion = new TextureRegion[7][3];
    public ForgeDirection side;
    public ForgeDirection insertDirection;
    public ForgeDirection rotation;
    public ForgeDirection relativeSide;
    public boolean isFrontSide = false;
    protected IAdvancedTile tile;
    private boolean adventureModeRestriction;

    public GuiInsertDirection(IGuiParent parent, int x, int y, IAdvancedTile tile, ForgeDirection side, ForgeDirection relativeSide) {
        super(parent, x, y, 16, 16);
        this.relativeSide = relativeSide;
        this.side = side;
        this.tile = tile;
        this.insertDirection = ForgeDirection.getOrientation((int)tile.getInsertDirection()[side.ordinal()]);
        String[] faceTextures = new String[]{"purple", "red", "orange", "yellow", "blue", "green"};
        TextureRegion textureRegion = SharedAtlas.findRegion("face_front");
        this.textureRegion[0][2] = textureRegion;
        this.textureRegion[0][1] = textureRegion;
        this.textureRegion[0][0] = textureRegion;
        for (int i = 0; i < faceTextures.length; ++i) {
            this.textureRegion[i + 1][0] = SharedAtlas.findRegion("face_" + faceTextures[i]);
            this.textureRegion[i + 1][1] = SharedAtlas.findRegion("face_" + faceTextures[i] + "_hover");
            this.textureRegion[i + 1][2] = SharedAtlas.findRegion("face_" + faceTextures[i] + "_inactive");
        }
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            TileEntity tile = (TileEntity)this.tile;
            if (tile instanceof TileAdvancedBuffer) {
                tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.PRIORITY_ORDER) + ": \u00a7r" + (((TileAdvancedBuffer)tile).getInsertDirection()[this.side.ordinal()] + 1));
            }
            tooltip.add("\u00a7a" + StatCollector.func_74838_a((String)(Strings.DIRECTION + this.side.ordinal())) + " \u00a7r(" + BlockHelper.getBlockDisplayName(tile.func_145831_w(), tile.field_145851_c + this.side.offsetX, tile.field_145848_d + this.side.offsetY, tile.field_145849_e + this.side.offsetZ, this.side) + ")");
            if (tile instanceof TileBlockExtender) {
                TileBlockExtender blockExtender = (TileBlockExtender)tile;
                boolean bl = this.isFrontSide = blockExtender.getConnectedDirection() == this.side;
                if (this.isFrontSide) {
                    String colorCode = "\u00a7";
                    String grayColor = colorCode + "7";
                    String yellowColor = colorCode + "e";
                    if (blockExtender.hasConnection()) {
                        tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.CONNECTED));
                        List<String> connections = blockExtender.getConnectionTypes();
                        for (int i = 0; i < connections.size(); ++i) {
                            connections.set(i, yellowColor + "* " + connections.get(i));
                        }
                        tooltip.addAll(connections);
                    } else {
                        tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.NOT_CONNECTED));
                    }
                } else {
                    tooltip.add("\u00a7a" + StatCollector.func_74838_a((String)Strings.INSERT_EXTRACT) + ": \u00a7r" + StatCollector.func_74838_a((String)(Strings.DIRECTION + this.insertDirection.ordinal())));
                    tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
                }
            }
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FontRenderer fontRendererObj = this.mc.field_71466_p;
        boolean isHovered = this.isInsideBounds(mouseX, mouseY);
        int faceIndex = (this.relativeSide != null ? this.relativeSide.ordinal() : this.side.ordinal()) + 1;
        if (this.tile instanceof TileBlockExtender) {
            TileBlockExtender blockExtender = (TileBlockExtender)((Object)this.tile);
            this.isFrontSide = blockExtender.getConnectedDirection() == this.side;
            boolean hasTile = blockExtender.getTiles()[this.side.ordinal()] != null;
            this.textureRegion[this.isFrontSide ? 0 : faceIndex][isHovered ? 1 : (hasTile ? 0 : 2)].draw(this.x, this.y);
            if (!this.isFrontSide) {
                this.insertDirection = ForgeDirection.getOrientation((int)this.tile.getInsertDirection()[this.side.ordinal()]);
                char letter = this.insertDirection.toString().charAt(0);
                fontRendererObj.func_85187_a(Character.toString(letter), this.x + this.w / 2 - fontRendererObj.func_78263_a(letter) / 2, this.y + this.h / 2 - fontRendererObj.field_78288_b / 2, hasTile || isHovered ? 0xFFFFFF : 0xAAAAAA, true);
            }
        } else if (this.tile instanceof TileAdvancedBuffer) {
            this.textureRegion[this.isFrontSide ? 0 : faceIndex][isHovered ? 1 : 0].draw(this.x, this.y);
            TileAdvancedBuffer buffer = (TileAdvancedBuffer)this.tile;
            byte p = buffer.getPriority(this.side.ordinal());
            String priority = p == TileAdvancedBuffer.NULL_PRIORITY ? "--" : Byte.toString((byte)(p + 1));
            fontRendererObj.func_85187_a(priority, this.x + this.w / 2 - fontRendererObj.func_78256_a(priority) / 2, this.y + this.h / 2 - fontRendererObj.field_78288_b / 2, isHovered ? 0xFFFFFF : 0xAAAAAA, true);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (!(type != 0 && type != 1 || this.isFrontSide || !this.isInsideBounds(mouseX, mouseY) || this.isAdventureModeRestriction() && GuiRefinedRelocationContainer.isRestrictedAccessWithError())) {
            byte step;
            if (this.tile instanceof TileBlockExtender) {
                step = (byte)(type == 0 ? 1 : -1);
                this.tile.setInsertDirection(this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()] + step);
                GuiHelper.sendByteMessage(11 + this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()]);
            }
            if (this.tile instanceof TileAdvancedBuffer) {
                step = (byte)(type == 0 ? -1 : 1);
                if (isShiftKeyDown) {
                    step = (byte)(step * 6);
                }
                this.tile.setInsertDirection(this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()] + step);
                GuiHelper.sendByteMessage(11 + this.side.ordinal(), this.tile.getInsertDirection()[this.side.ordinal()]);
            }
        }
    }

    public final boolean isAdventureModeRestriction() {
        return this.adventureModeRestriction;
    }

    public void setAdventureModeRestriction(boolean adventureModeRestriction) {
        this.adventureModeRestriction = adventureModeRestriction;
    }
}

