/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.api.filter.IMultiFilterChild;
import com.dynious.refinedrelocation.api.gui.IGuiWidgetWrapped;
import com.dynious.refinedrelocation.client.gui.GuiFiltered;
import com.dynious.refinedrelocation.client.gui.widget.GuiLabel;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonFilterType;
import com.dynious.refinedrelocation.grid.filter.MultiFilterRegistry;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFilterTypeList
extends GuiWidgetBase
implements IGuiWidgetWrapped {
    private static final int ROW_HEIGHT = 27;
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_AREA_WIDTH = 10;
    private static final int SCROLLBAR_WIDTH = 7;
    private final int numFiltersPerScreen;
    private final int listOffsetY;
    private int scrollBarScaledHeight;
    private int scrollBarYPos;
    private int scrollBarXPos;
    public int mouseClickY = -1;
    public int indexWhenClicked;
    public int lastNumberOfMoves;
    protected int currentIndex = 0;
    protected final GuiButtonFilterType[] filterTypes;
    protected final List<IMultiFilterChild> availableFilters = new ArrayList<IMultiFilterChild>();

    public GuiFilterTypeList(GuiFiltered parent, int x, int y, int w, int h) {
        super(x, y, w, h);
        for (Class<? extends IMultiFilterChild> entry : MultiFilterRegistry.getFilters()) {
            try {
                IMultiFilterChild filterChild = entry.newInstance();
                if (!filterChild.canFilterBeUsedOnTile(parent.getFilter().getFilterTile().getTileEntity())) continue;
                this.availableFilters.add(filterChild);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        GuiLabel headerLabel = new GuiLabel(this, x, y, StatCollector.func_74838_a((String)Strings.SELECT_FILTER_TYPE));
        headerLabel.drawCentered = false;
        this.listOffsetY = headerLabel.h + 10;
        this.numFiltersPerScreen = (int)Math.floor((h - this.listOffsetY) / 27);
        int curY = y + this.listOffsetY;
        this.filterTypes = new GuiButtonFilterType[this.numFiltersPerScreen];
        for (int i = 0; i < this.numFiltersPerScreen; ++i) {
            this.filterTypes[i] = new GuiButtonFilterType(this, x, curY);
            this.filterTypes[i].setFilter(i + this.currentIndex < this.availableFilters.size() ? this.availableFilters.get(i + this.currentIndex) : null);
            curY += 26;
        }
        this.recalculateScrollBar();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index = Math.min(Math.max(this.availableFilters.size() - this.numFiltersPerScreen, 0), Math.max(0, index));
        for (int i = 0; i < this.numFiltersPerScreen; ++i) {
            this.filterTypes[i].setFilter(i + this.currentIndex < this.availableFilters.size() ? this.availableFilters.get(i + this.currentIndex) : null);
        }
        this.recalculateScrollBar();
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = 102;
        this.scrollBarScaledHeight = (int)((float)scrollBarTotalHeight * Math.min(1.0f, (float)this.numFiltersPerScreen / (float)this.availableFilters.size()));
        this.scrollBarYPos = this.y + this.listOffsetY + 1 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentIndex / Math.max(1, this.availableFilters.size() - this.numFiltersPerScreen);
        this.scrollBarXPos = this.x + 1 + this.w - 5 + 3 + 1;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.mouseClickY != -1 && (pixelsPerFilter = ((float)this.h - (float)this.listOffsetY - 4.0f - (float)this.scrollBarScaledHeight) / (float)(this.availableFilters.size() - this.numFiltersPerScreen)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentIndex(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawBackground(mouseX, mouseY);
        this.mc.func_110434_K().func_110577_a(Resources.GUI_MODULAR_FILTER);
        this.func_73729_b(this.x + 8 + this.w - 10 - 7, this.y + this.listOffsetY, 162, 54, 11, 105);
        GuiContainer.func_73734_a((int)(this.scrollBarXPos - 7), (int)this.scrollBarYPos, (int)this.scrollBarXPos, (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
    }

    @Override
    public void handleMouseInput() {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i == 0) {
            return;
        }
        this.setCurrentIndex(i > 0 ? this.getCurrentIndex() - 1 : this.getCurrentIndex() + 1);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        if (mouseX >= this.scrollBarXPos - 7 && mouseX <= this.scrollBarXPos && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.getCurrentIndex();
        }
    }

    @Override
    public void mouseMovedOrUp(int mouseX, int mouseY, int type) {
        super.mouseMovedOrUp(mouseX, mouseY, type);
        if (type != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }
}

