/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.api.filter.IChecklistFilter;
import com.dynious.refinedrelocation.api.gui.IGuiWidgetWrapped;
import com.dynious.refinedrelocation.client.gui.widget.GuiCheckboxFilter;
import com.dynious.refinedrelocation.client.gui.widget.GuiLabel;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import com.dynious.refinedrelocation.lib.Resources;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFilterList
extends GuiWidgetBase
implements IGuiWidgetWrapped {
    private static final int ROW_SPACING = 1;
    private static final int ROW_HEIGHT = 10;
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_AREA_WIDTH = 10;
    private static final int SCROLLBAR_WIDTH = 7;
    private final int numFiltersPerScreen;
    private final int listOffsetY;
    private int scrollBarScaledHeight;
    private int scrollBarYPos;
    private int scrollBarXPos;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    protected IChecklistFilter filter;
    protected int currentIndex = 0;
    protected GuiCheckboxFilter[] filters;

    public GuiFilterList(int x, int y, int w, int h, IChecklistFilter filter) {
        super(x, y, w, h);
        this.filter = filter;
        GuiLabel headerLabel = new GuiLabel(this, x, y, StatCollector.func_74838_a((String)filter.getNameLangKey()));
        headerLabel.drawCentered = false;
        this.listOffsetY = headerLabel.h + 8;
        this.numFiltersPerScreen = (int)Math.min(Math.floor((h - this.listOffsetY + 2) / 11), (double)filter.getOptionCount());
        this.filters = new GuiCheckboxFilter[this.numFiltersPerScreen];
        for (int i = 0; i < this.numFiltersPerScreen; ++i) {
            this.filters[i] = new GuiCheckboxFilter(this, x, y + this.listOffsetY + i * 11, w - 10, 10, i, filter);
            this.filters[i].setAdventureModeRestriction(true);
        }
        this.recalculateScrollBar();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index = Math.min(this.filter.getOptionCount() - this.numFiltersPerScreen, Math.max(0, index));
        for (int i = 0; i < this.numFiltersPerScreen; ++i) {
            this.filters[i].setIndex(i + this.currentIndex);
        }
        this.recalculateScrollBar();
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = this.h - this.listOffsetY - 4;
        this.scrollBarScaledHeight = (int)((float)scrollBarTotalHeight * Math.min(1.0f, (float)this.numFiltersPerScreen / (float)this.filter.getOptionCount()));
        this.scrollBarYPos = this.y + this.listOffsetY + 1 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentIndex / Math.max(1, this.filter.getOptionCount() - this.numFiltersPerScreen);
        this.scrollBarXPos = this.x + 1 + this.w - 5 + 3 + 1;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(Resources.GUI_MODULAR_FILTER);
        this.func_73729_b(this.x, this.y + this.listOffsetY, 0, 0, 162, 121);
        if (this.mouseClickY != -1 && (pixelsPerFilter = ((float)this.h - (float)this.listOffsetY - 4.0f - (float)this.scrollBarScaledHeight) / (float)(this.filter.getOptionCount() - this.numFiltersPerScreen)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentIndex(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiContainer.func_73734_a((int)(this.scrollBarXPos - 7), (int)this.scrollBarYPos, (int)this.scrollBarXPos, (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        super.drawBackground(mouseX, mouseY);
    }

    @Override
    public void handleMouseInput() {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i == 0) {
            return;
        }
        this.setCurrentIndex(i > 0 ? this.getCurrentIndex() - 1 : this.getCurrentIndex() + 1);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        if (mouseX >= this.scrollBarXPos - 7 && mouseX <= this.scrollBarXPos && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.getCurrentIndex();
        }
    }

    @Override
    public void mouseMovedOrUp(int mouseX, int mouseY, int type) {
        super.mouseMovedOrUp(mouseX, mouseY, type);
        if (type != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }
}

