/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.IGuiWidgetBase;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import com.dynious.refinedrelocation.container.ContainerRefinedRelocation;
import com.dynious.refinedrelocation.lib.Settings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiRefinedRelocationContainer
extends GuiContainer
implements IGuiParent {
    private static TextureRegion[][] windowTexture;
    protected IGuiWidgetBase rootNode;
    private final List<String> tmpTooltip = new ArrayList<String>();

    public GuiRefinedRelocationContainer(ContainerRefinedRelocation container) {
        super((Container)container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.rootNode = new GuiWidgetBase(0, 0, this.field_146294_l, this.field_146295_m){};
        this.clearChildren();
    }

    public int getLeft() {
        return this.field_147003_i;
    }

    public int getTop() {
        return this.field_147009_r;
    }

    @Override
    public void addChild(IGuiWidgetBase child) {
        this.rootNode.addChild(child);
    }

    @Override
    public void addChildren(List<IGuiWidgetBase> children) {
        this.rootNode.addChildren(children);
    }

    @Override
    public void clearChildren() {
        this.rootNode.clearChildren();
    }

    @Override
    public boolean removeChild(IGuiWidgetBase child) {
        return this.rootNode.removeChild(child);
    }

    @Override
    public void removeChildren(List<IGuiWidgetBase> children) {
        this.rootNode.removeChildren(children);
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.rootNode.drawBackground(mouseX, mouseY);
        GL11.glPopMatrix();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.rootNode.drawForeground(mouseX, mouseY);
        GL11.glPopMatrix();
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        IGuiWidgetBase child = this.rootNode.getChildAt(mouseX, mouseY);
        if (child != null) {
            this.tmpTooltip.clear();
            this.rootNode.getTooltip(this.tmpTooltip, mouseX, mouseY);
            if (!this.tmpTooltip.isEmpty()) {
                this.drawHoveringText(this.tmpTooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.rootNode.update();
    }

    protected void func_73864_a(int mouseX, int mouseY, int type) {
        IGuiWidgetBase child = this.rootNode.getChildAt(mouseX, mouseY);
        if (child != null) {
            child.mouseClicked(mouseX, mouseY, type, GuiRefinedRelocationContainer.func_146272_n());
        }
        super.func_73864_a(mouseX, mouseY, type);
    }

    public void func_146274_d() {
        this.rootNode.handleMouseInput();
        super.func_146274_d();
    }

    public void func_73869_a(char c, int i) {
        if (!this.rootNode.keyTyped(c, i)) {
            super.func_73869_a(c, i);
        }
    }

    public void func_146286_b(int par1, int par2, int par3) {
        this.rootNode.mouseMovedOrUp(par1, par2, par3);
        super.func_146286_b(par1, par2, par3);
    }

    @Override
    public ContainerRefinedRelocation getContainer() {
        return (ContainerRefinedRelocation)this.field_147002_h;
    }

    public static boolean isRestrictedAccess() {
        return Settings.ENABLE_ADVENTURE_MODE_RESTRICTION && Minecraft.func_71410_x().field_71442_b.field_78779_k.func_82752_c();
    }

    public static boolean isRestrictedAccessWithError() {
        if (GuiRefinedRelocationContainer.isRestrictedAccess()) {
            ChatComponentText chatComponent = new ChatComponentText(StatCollector.func_74838_a((String)"misc.refinedrelocation.adventureMode"));
            chatComponent.func_150256_b().func_150238_a(EnumChatFormatting.DARK_RED);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)chatComponent);
            return true;
        }
        return false;
    }

    public static void drawWindow(int x, int y, int width, int height) {
        if (windowTexture == null) {
            windowTexture = new TextureRegion[3][3];
            GuiRefinedRelocationContainer.windowTexture[0][0] = SharedAtlas.findRegion("window_corner_tl");
            GuiRefinedRelocationContainer.windowTexture[1][0] = SharedAtlas.findRegion("window_border_top");
            GuiRefinedRelocationContainer.windowTexture[2][0] = SharedAtlas.findRegion("window_corner_tr");
            GuiRefinedRelocationContainer.windowTexture[0][1] = SharedAtlas.findRegion("window_border_left");
            GuiRefinedRelocationContainer.windowTexture[1][1] = SharedAtlas.findRegion("window_center");
            GuiRefinedRelocationContainer.windowTexture[2][1] = SharedAtlas.findRegion("window_border_right");
            GuiRefinedRelocationContainer.windowTexture[0][2] = SharedAtlas.findRegion("window_corner_bl");
            GuiRefinedRelocationContainer.windowTexture[1][2] = SharedAtlas.findRegion("window_border_bottom");
            GuiRefinedRelocationContainer.windowTexture[2][2] = SharedAtlas.findRegion("window_corner_br");
        }
        int borderSize = windowTexture[0][0].getRegionWidth();
        windowTexture[0][0].draw(x, y);
        windowTexture[1][0].draw(x + borderSize, y, width - borderSize * 2, borderSize);
        windowTexture[2][0].draw(x + width - borderSize, y);
        windowTexture[0][1].draw(x, y + borderSize, borderSize, height - borderSize * 2);
        windowTexture[1][1].draw(x + borderSize, y + borderSize, width - borderSize * 2, height - borderSize * 2);
        windowTexture[2][1].draw(x + width - borderSize, y + borderSize, borderSize, height - borderSize * 2);
        windowTexture[0][2].draw(x, y + height - borderSize);
        windowTexture[1][2].draw(x + borderSize, y + height - borderSize, width - borderSize * 2, borderSize);
        windowTexture[2][2].draw(x + width - borderSize, y + height - borderSize);
    }
}

