/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.block;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.lib.RelocatorData;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.repack.codechicken.lib.raytracer.IndexedCuboid6;
import com.dynious.refinedrelocation.repack.codechicken.lib.raytracer.RayTracer;
import com.dynious.refinedrelocation.repack.codechicken.lib.vec.BlockCoord;
import com.dynious.refinedrelocation.repack.codechicken.lib.vec.Vector3;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRelocator
extends BlockContainer {
    private RayTracer rayTracer = new RayTracer();

    protected BlockRelocator() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149647_a(RefinedRelocation.tabRefinedRelocation);
        this.func_149663_c("relocator");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileRelocator();
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator) {
            ((TileRelocator)tile).onBlocksChanged();
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator) {
            return ((TileRelocator)tile).shouldConnectToRedstone();
        }
        return false;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator) {
            return ((TileRelocator)tile).isProvidingStrongPower(side);
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149748_c(world, x, y, z, side);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator) {
            for (ItemStack stack : ((TileRelocator)tile).getDrops()) {
                IOHelper.spawnItemInWorld(world, stack, x, y, z);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        MovingObjectPosition hit;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator && (hit = RayTracer.retraceBlock(world, player, x, y, z)) != null) {
            return ((TileRelocator)tile).onActivated(player, hit, player.func_70694_bm());
        }
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        boolean breakBlock;
        MovingObjectPosition hit;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator && (hit = RayTracer.retraceBlock(world, player, x, y, z)) != null && (breakBlock = ((TileRelocator)tile).leftClick(player, hit, player.func_70694_bm()))) {
            super.func_149699_a(world, x, y, z, player);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        MovingObjectPosition hit;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator && (hit = RayTracer.retraceBlock(world, player, x, y, z)) != null && !((TileRelocator)tile).leftClick(player, hit, player.func_70694_bm())) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List collisionList, Entity entity) {
        RelocatorData.middleCuboid.setBlockBounds((Block)this);
        super.func_149743_a(world, x, y, z, axisAlignedBB, collisionList, entity);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileRelocator) {
            TileRelocator relocator = (TileRelocator)tile;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (!relocator.connectsToSide(i)) continue;
                RelocatorData.sideCuboids[i].setBlockBounds((Block)this);
            }
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileRelocator) {
            ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (!((TileRelocator)tile).connectsToSide(i)) continue;
                cuboids.add(new IndexedCuboid6(i, RelocatorData.sideCuboids[i].copy().add(Vector3.fromTileEntity(tile))));
            }
            cuboids.add(new IndexedCuboid6(6, RelocatorData.middleCuboid.copy().add(Vector3.fromTileEntity(tile))));
            return this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
        }
        return null;
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a(Resources.MOD_ID + ":relocatorCenter0");
    }
}

