/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import nc.NuclearCraft;
import nc.block.machine.BlockElectricFurnace;
import nc.item.NCItems;
import nc.tile.machine.TileInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileElectricFurnace
extends TileInventory
implements IEnergyHandler,
IEnergyReceiver {
    public EnergyStorage energyStorage;
    public boolean flag;
    public boolean flag1 = false;
    public int top;
    public int bottom;
    public int side1;
    public int recipe;
    public int energy;
    public int cookTime = 0;
    public boolean update;
    public static final int[] automation = new int[]{0, 1};
    public int currentItemBurnTime;
    public double speedUpgrade = 1.0;
    public double energyUpgrade = 1.0;
    public double getFurnaceSpeed = Math.ceil(this.FurnaceSpeed() / this.speedUpgrade);
    public double getRequiredEnergy = Math.ceil(this.speedUpgrade * (this.RequiredEnergy() / this.energyUpgrade));

    public TileElectricFurnace() {
        this.energyStorage = new EnergyStorage(250000, 250000);
        this.localizedName = "electricFurnace";
        this.slots = new ItemStack[4];
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.upgradeSpeed();
        this.upgradeEnergy();
        this.getFurnaceSpeed = Math.ceil(this.FurnaceSpeed() / this.speedUpgrade);
        this.getRequiredEnergy = Math.ceil(this.speedUpgrade * (this.RequiredEnergy() / this.energyUpgrade));
        if (!this.field_145850_b.field_72995_K) {
            this.canCook();
            if (this.canCook()) {
                ++this.cookTime;
                this.energyStorage.extractEnergy((int)Math.ceil(this.getRequiredEnergy / this.getFurnaceSpeed), false);
                if ((double)this.cookTime >= this.getFurnaceSpeed) {
                    this.cookTime = 0;
                    this.cookItem();
                }
            } else {
                this.cookTime = 0;
            }
        }
        if (this.flag != this.flag1) {
            this.flag1 = this.flag;
            BlockElectricFurnace.updateBlockState(this.flag, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    public ItemStack getOutput(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public int getInputSize(ItemStack stack, int slot) {
        return 1;
    }

    public boolean canCook() {
        if (this.slots[0] == null) {
            this.flag = false;
            return false;
        }
        if ((double)this.cookTime >= this.getFurnaceSpeed) {
            this.flag = true;
            return true;
        }
        if (this.getRequiredEnergy > (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() - (int)Math.ceil(this.getRequiredEnergy / this.getFurnaceSpeed)) {
            this.flag = false;
            return false;
        }
        if (this.getRequiredEnergy < (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.getRequiredEnergy > (double)this.energyStorage.getEnergyStored()) {
            this.flag = false;
            return false;
        }
        if (this.energyStorage.getEnergyStored() < 1 * (int)Math.ceil(this.getRequiredEnergy / this.getFurnaceSpeed)) {
            this.flag = false;
            return false;
        }
        if (this.energyStorage.getEnergyStored() == 0) {
            this.flag = false;
            return false;
        }
        ItemStack itemstack = this.getOutput(this.slots[0]);
        if (itemstack == null) {
            this.flag = false;
            return false;
        }
        if (this.slots[1] != null) {
            if (!this.slots[1].func_77969_a(itemstack)) {
                this.flag = false;
                return false;
            }
            if (this.slots[1].field_77994_a + itemstack.field_77994_a > this.slots[1].func_77976_d()) {
                this.flag = false;
                return false;
            }
        }
        this.flag = true;
        return true;
    }

    private void cookItem() {
        ItemStack itemstack = this.getOutput(this.slots[0]);
        if (this.slots[1] == null) {
            this.slots[1] = itemstack.func_77946_l();
        } else if (this.slots[1].func_77969_a(itemstack)) {
            this.slots[1].field_77994_a += itemstack.field_77994_a;
        }
        this.slots[0].field_77994_a -= this.getInputSize(this.slots[0], 0);
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
    }

    public void upgradeSpeed() {
        ItemStack stack = this.func_70301_a(2);
        this.speedUpgrade = stack != null && TileElectricFurnace.isSpeedUpgrade(stack) ? Math.pow(1.8, stack.field_77994_a) : 1.0;
    }

    public static boolean isSpeedUpgrade(ItemStack stack) {
        return stack.func_77973_b() == NCItems.upgradeSpeed;
    }

    public void upgradeEnergy() {
        ItemStack stack = this.func_70301_a(3);
        this.energyUpgrade = stack != null && TileElectricFurnace.isEnergyUpgrade(stack) ? Math.pow(1.7, stack.field_77994_a) : 1.0;
    }

    public static boolean isEnergyUpgrade(ItemStack stack) {
        return stack.func_77973_b() == NCItems.upgradeEnergy;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("energyStorage")) {
            this.energyStorage.readFromNBT(nbt.func_74775_l("energyStorage"));
            this.speedUpgrade = nbt.func_74769_h("sU");
            this.energyUpgrade = nbt.func_74769_h("eU");
            this.getFurnaceSpeed = nbt.func_74769_h("s");
            this.getRequiredEnergy = nbt.func_74769_h("e");
        }
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= this.slots.length) continue;
            this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.cookTime = nbt.func_74765_d("CookTime");
        this.top = nbt.func_74765_d("Top");
        this.bottom = nbt.func_74765_d("Bottom");
        this.side1 = nbt.func_74765_d("Side1");
        this.flag = nbt.func_74767_n("flag");
        this.flag1 = nbt.func_74767_n("flag1");
    }

    public void readSides(NBTTagCompound nbt) {
        this.top = nbt.func_74765_d("Top");
        this.bottom = nbt.func_74765_d("Bottom");
        this.side1 = nbt.func_74765_d("Side1");
    }

    public void readEnergy(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energyStorage")) {
            this.energyStorage.readFromNBT(nbt.func_74775_l("energyStorage"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        nbt.func_74782_a("energyStorage", (NBTBase)energyTag);
        NBTTagList list = new NBTTagList();
        nbt.func_74757_a("flag", this.flag);
        nbt.func_74757_a("flag1", this.flag1);
        nbt.func_74780_a("sU", this.speedUpgrade);
        nbt.func_74780_a("eU", this.energyUpgrade);
        nbt.func_74780_a("s", this.getFurnaceSpeed);
        nbt.func_74780_a("e", this.getRequiredEnergy);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        nbt.func_74777_a("Top", (short)this.top);
        nbt.func_74777_a("Bottom", (short)this.bottom);
        nbt.func_74777_a("Side1", (short)this.side1);
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public void writeSides(NBTTagCompound nbt) {
        nbt.func_74777_a("Top", (short)this.top);
        nbt.func_74777_a("Bottom", (short)this.bottom);
        nbt.func_74777_a("Side1", (short)this.side1);
        this.update = false;
    }

    public void writeEnergy(NBTTagCompound nbt) {
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        nbt.func_74782_a("energyStorage", (NBTBase)energyTag);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        this.writeSides(nbtTag);
        this.writeEnergy(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readSides(packet.func_148857_g());
        this.readEnergy(packet.func_148857_g());
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergy() {
        if (this.energyStorage.getEnergyStored() == 0) {
            return this.energy;
        }
        return this.energyStorage.getEnergyStored();
    }

    public double FurnaceSpeed() {
        return 100 * (100 / NuclearCraft.electricFurnaceSmeltSpeed);
    }

    public double RequiredEnergy() {
        return 2000 * (100 / NuclearCraft.electricFurnaceSmeltEfficiency);
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int j) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int j) {
        return slot == 1;
    }

    public String getName() {
        return this.func_145838_q().func_149739_a();
    }

    public int getType() {
        return this.func_145832_p();
    }

    public int[] func_94128_d(int var1) {
        return automation;
    }
}

