/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import nc.NuclearCraft;
import nc.tile.generator.TileContinuousBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSteamGenerator
extends TileContinuousBase
implements IFluidHandler {
    public int fluid;
    public FluidTank tank = new FluidTank(NuclearCraft.steamRFUsageRate);

    public TileSteamGenerator() {
        super("steamGenerator", NuclearCraft.steamRFUsageRate * 20);
    }

    @Override
    public void energy() {
        this.storage.receiveEnergy(2 * this.tank.getFluidAmount(), false);
        this.tank.drain(this.tank.getFluidAmount(), true);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == NuclearCraft.steam || fluid == FluidRegistry.getFluid((String)"steam");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.tank.writeToNBT(fluidTag);
        nbt.func_74782_a("tank", (NBTBase)fluidTag);
    }

    public void writeFluid(NBTTagCompound nbt) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.tank.writeToNBT(fluidTag);
        nbt.func_74782_a("tank", (NBTBase)fluidTag);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("fluid", this.tank.getFluidAmount());
        this.fluid = nbtTag.func_74762_e("fluid");
        this.writeFluid(nbtTag);
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void readFluid(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readFluid(packet.func_148857_g());
        this.func_145839_a(packet.func_148857_g());
    }
}

