/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import me.planetguy.lib.PlanetguyLib;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Debug {
    static final Logger log = LogManager.getLogger((String)"PL");
    private static List<Class> baseClasses = Arrays.asList(Object.class, TileEntity.class, Entity.class);

    public static void print(String s) {
        if (PlanetguyLib.doPLLogging) {
            log.info(s);
        }
    }

    public static void dbt(Object o) {
        Object[] trace = Thread.currentThread().getStackTrace();
        Debug.dbg(Arrays.toString(trace) + " >>> " + o);
    }

    public static void dbg_delegate(Object o) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        Debug.print(trace[3].getClassName().replaceAll("[a-zA-Z]*\\.", "") + "@" + trace[3].getLineNumber() + "   " + o);
    }

    public static void dbg(Object o) {
        Debug.dbg_delegate(o);
    }

    public static void exception(Throwable t) {
        Debug.dbg(t.toString());
    }

    @Deprecated
    public static String dump(Object o) {
        String ret = "";
        if (o == null) {
            ret = ret + "NULL";
        } else {
            ret = ret + o.getClass();
            for (Field f : o.getClass().getFields()) {
                try {
                    ret = ret + f.getName() + ":   " + f.get(o);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public static void details(Object o) {
        Debug.dbg_delegate("Detailed class dump:");
        if (o != null) {
            Class<?> c = o.getClass();
            Debug.print(c + "(" + FMLCommonHandler.instance().getEffectiveSide() + ") @" + System.identityHashCode(o));
            while (!baseClasses.contains(c)) {
                for (Field f : c.getDeclaredFields()) {
                    if ((f.getModifiers() & 8) != 0) continue;
                    try {
                        f.setAccessible(true);
                        Object obj = f.get(o);
                        if (obj != null && obj.getClass().isArray()) {
                            for (int i = 0; i < Array.getLength(obj); ++i) {
                                Debug.print("   " + f.getName() + "     " + i + "     " + Array.get(obj, i));
                            }
                            continue;
                        }
                        Debug.print("   " + f.getName() + "     " + obj);
                    }
                    catch (Exception e) {
                        Debug.print("" + e);
                    }
                }
                c = c.getSuperclass();
            }
        }
    }

    public static void mark() {
        Debug.dbg_delegate("executed");
    }

    public static void side() {
        Debug.dbg_delegate(FMLCommonHandler.instance().getEffectiveSide());
    }

    public static void bp() {
        if (PlanetguyLib.doPLLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Minecraft.func_71410_x().field_71417_B.func_74373_b();
            Debug.dbg_delegate("Ready for debugging!");
        }
    }
}

