/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketParticle;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMiner
extends TileEntityInventoryBase
implements IEnergyReceiver,
IButtonReactor,
IEnergySaver,
IEnergyDisplay {
    public static final int ENERGY_USE_PER_BLOCK = 500;
    public static final int DEFAULT_RANGE = 2;
    public EnergyStorage storage = new EnergyStorage(1000000);
    public int layerAt = -1;
    public boolean onlyMineOres = true;
    private int oldLayerAt;
    private int oldEnergy;

    public TileEntityMiner() {
        super(9, "miner");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.layerAt == -1) {
                this.layerAt = this.field_145848_d - 1;
            }
            if (!this.isRedstonePowered && this.ticksElapsed % 5 == 0 && this.layerAt > 0 && this.mine(TileEntityPhantomface.upgradeRange(2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
                --this.layerAt;
            }
            if ((this.oldEnergy != this.storage.getEnergyStored() || this.oldLayerAt != this.layerAt) && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
                this.oldLayerAt = this.layerAt;
            }
        }
    }

    private boolean mine(int range) {
        for (int anX = -range; anX <= range; ++anX) {
            for (int aZ = -range; aZ <= range; ++aZ) {
                int actualUse = 500 * (this.onlyMineOres ? 3 : 1);
                if (this.storage.getEnergyStored() >= actualUse) {
                    int x = this.field_145851_c + anX;
                    int z = this.field_145849_e + aZ;
                    int y = this.layerAt;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    int meta = this.field_145850_b.func_72805_g(x, y, z);
                    if (block == null || block.isAir((IBlockAccess)this.field_145850_b, x, y, z) || !((float)block.getHarvestLevel(meta) <= 3.0f) || !(block.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f) || block instanceof BlockLiquid || block instanceof IFluidBlock || !this.isMinable(block, meta)) continue;
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    drops.addAll(block.getDrops(this.field_145850_b, x, y, z, meta, 0));
                    if (WorldUtil.addToInventory((IInventory)this, drops, ForgeDirection.UNKNOWN, false)) {
                        this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                        this.field_145850_b.func_147468_f(x, y, z);
                        WorldUtil.addToInventory((IInventory)this, drops, ForgeDirection.UNKNOWN, true);
                        this.func_70296_d();
                        this.storage.extractEnergy(actualUse, false);
                        this.shootParticles(x, y, z);
                    }
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private boolean isMinable(Block block, int meta) {
        if (!this.isBlacklisted(block)) {
            int[] ids;
            if (!this.onlyMineOres) {
                return true;
            }
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(block, 1, meta))) {
                String name = OreDictionary.getOreName((int)id);
                if (!name.startsWith("ore") && !name.startsWith("denseore")) continue;
                return true;
            }
            String reg = Block.field_149771_c.func_148750_c((Object)block);
            if (reg != null && !reg.isEmpty()) {
                for (String string : ConfigValues.minerExtraWhitelist) {
                    if (!reg.equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isBlacklisted(Block block) {
        String reg = Block.field_149771_c.func_148750_c((Object)block);
        if (reg != null && !reg.isEmpty()) {
            for (String string : ConfigValues.minerBlacklist) {
                if (!reg.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void shootParticles(int endX, int endY, int endZ) {
        PacketHandler.theNetwork.sendToAllAround((IMessage)new PacketParticle(this.field_145851_c, this.field_145848_d, this.field_145849_e, endX, endY, endZ, new float[]{0.24313726f, 0.6392157f, 0.2901961f}, 5, 1.0f), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 96.0));
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
        compound.func_74768_a("Layer", this.layerAt);
        compound.func_74757_a("OnlyOres", this.onlyMineOres);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
        this.layerAt = compound.func_74762_e("Layer");
        this.onlyMineOres = compound.func_74767_n("OnlyOres");
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.onlyMineOres = !this.onlyMineOres;
            this.sendUpdate();
        } else if (buttonID == 1) {
            this.layerAt = -1;
        }
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }
}

