/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChest;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockGiantChest
extends BlockContainerBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;

    public BlockGiantChest(String name) {
        super(Material.field_151575_d, name);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(15.0f);
        this.func_149672_a(field_149766_f);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityGiantChest();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 1 ? this.topIcon : (side == 0 ? this.bottomIcon : this.field_149761_L);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            TileEntityGiantChest chest = (TileEntityGiantChest)world.func_147438_o(x, y, z);
            if (chest != null) {
                player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.GIANT_CHEST.ordinal(), world, x, y, z);
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.field_149761_L = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
        this.topIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Top");
        this.bottomIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Bottom");
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.epic;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77978_p() != null && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityGiantChest) {
            NBTTagList list = stack.func_77978_p().func_150295_c("Items", 10);
            ItemStack[] slots = ((TileEntityGiantChest)tile).slots;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                slots[i] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
            }
        }
        super.func_149689_a(world, x, y, z, entity, stack);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ItemStack[] slots;
        int place;
        ArrayList<ItemStack> drops = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityGiantChest && (place = ItemUtil.getPlaceAt(slots = ((TileEntityGiantChest)tile).slots, new ItemStack(InitItems.itemCrateKeeper), false)) >= 0) {
            ItemStack stackInQuestion;
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < slots.length; ++i) {
                if (i == place || slots[i] == null) continue;
                list.func_74742_a((NBTBase)slots[i].func_77955_b(new NBTTagCompound()));
            }
            if (list.func_74745_c() > 0 && (stackInQuestion = drops.get(0)) != null) {
                if (stackInQuestion.func_77978_p() == null) {
                    stackInQuestion.func_77982_d(new NBTTagCompound());
                }
                stackInQuestion.func_77978_p().func_74782_a("Items", (NBTBase)list);
            }
        }
        return drops;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityGiantChest && !ItemUtil.contains(((TileEntityGiantChest)tile).slots, new ItemStack(InitItems.itemCrateKeeper), false)) {
            this.dropInventory(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }
}

