/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import de.ellpeck.actuallyadditions.mod.achievement.InitAchievements;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.InitBooklet;
import de.ellpeck.actuallyadditions.mod.config.ConfigurationHandler;
import de.ellpeck.actuallyadditions.mod.crafting.CrusherCrafting;
import de.ellpeck.actuallyadditions.mod.crafting.InitCrafting;
import de.ellpeck.actuallyadditions.mod.crafting.ItemCrafting;
import de.ellpeck.actuallyadditions.mod.event.InitEvents;
import de.ellpeck.actuallyadditions.mod.gen.InitVillager;
import de.ellpeck.actuallyadditions.mod.gen.OreGen;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.InitForeignPaxels;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.lens.LensNoneRecipeHandler;
import de.ellpeck.actuallyadditions.mod.material.InitArmorMaterials;
import de.ellpeck.actuallyadditions.mod.material.InitToolMaterials;
import de.ellpeck.actuallyadditions.mod.misc.DispenserHandlerEmptyBucket;
import de.ellpeck.actuallyadditions.mod.misc.DispenserHandlerFertilize;
import de.ellpeck.actuallyadditions.mod.misc.DispenserHandlerFillBucket;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.misc.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.misc.WorldData;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.ore.InitOreDict;
import de.ellpeck.actuallyadditions.mod.proxy.IProxy;
import de.ellpeck.actuallyadditions.mod.recipe.FuelHandler;
import de.ellpeck.actuallyadditions.mod.recipe.HairyBallHandler;
import de.ellpeck.actuallyadditions.mod.recipe.TreasureChestHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.FakePlayerUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Locale;
import net.minecraft.init.Items;
import net.minecraft.server.MinecraftServer;

@Mod(modid="ActuallyAdditions", name="Actually Additions", version="1.7.10-r21", dependencies="after:BuildCraft|Energy", guiFactory="de.ellpeck.actuallyadditions.mod.config.GuiFactory")
public class ActuallyAdditions {
    @Mod.Instance(value="ActuallyAdditions")
    public static ActuallyAdditions instance;
    @SidedProxy(clientSide="de.ellpeck.actuallyadditions.mod.proxy.ClientProxy", serverSide="de.ellpeck.actuallyadditions.mod.proxy.ServerProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModUtil.LOGGER.info("Starting PreInitialization Phase...");
        new ConfigurationHandler(event.getSuggestedConfigurationFile());
        PacketHandler.init();
        InitToolMaterials.init();
        InitArmorMaterials.init();
        InitBlocks.init();
        InitItems.init();
        FuelHandler.init();
        UpdateChecker.init();
        InitBooklet.preInit();
        proxy.preInit(event);
        ModUtil.LOGGER.info("PreInitialization Finished.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModUtil.LOGGER.info("Starting Initialization Phase...");
        InitOreDict.init();
        InitAchievements.init();
        GuiHandler.init();
        OreGen.init();
        TileEntityBase.init();
        InitEvents.init();
        InitCrafting.init();
        DungeonLoot.init();
        proxy.init(event);
        ModUtil.LOGGER.info("Initialization Finished.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModUtil.LOGGER.info("Starting PostInitialization Phase...");
        InitVillager.init();
        ItemCoffee.initIngredients();
        CrusherCrafting.init();
        ItemCrafting.initMashedFoodRecipes();
        HairyBallHandler.init();
        TreasureChestHandler.init();
        LensNoneRecipeHandler.init();
        InitForeignPaxels.init();
        InitBooklet.postInit();
        proxy.postInit(event);
        ModUtil.LOGGER.info("PostInitialization Finished.");
        FakePlayerUtil.info();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        Util.registerDispenserHandler(InitItems.itemBucketOil, new DispenserHandlerEmptyBucket());
        Util.registerDispenserHandler(InitItems.itemBucketCanolaOil, new DispenserHandlerEmptyBucket());
        Util.registerDispenserHandler(Items.field_151133_ar, new DispenserHandlerFillBucket());
        Util.registerDispenserHandler(InitItems.itemFertilizer, new DispenserHandlerFertilize());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (LaserRelayConnectionHandler.getInstance() == null) {
            LaserRelayConnectionHandler.setInstance(new LaserRelayConnectionHandler());
        }
        WorldData.init(MinecraftServer.func_71276_C());
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name == null || !mapping.name.toLowerCase(Locale.ROOT).startsWith(ModUtil.MOD_ID_LOWER + ":") || !mapping.name.contains("paxel") && !mapping.name.contains("itemSpecial")) continue;
            mapping.ignore();
            ModUtil.LOGGER.info("Missing Mapping " + mapping.name + " is getting ignored. This is intentional.");
        }
    }
}

